/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.manager.notification;

import com.orhanobut.logger.Logger;
import com.xdja.baselibrary.base.BaseParams;
import com.xdja.baselibrary.rx.ObservableTransfor;
import com.xdja.moments.sdk.database.domain.MomentNotification;
import com.xdja.moments.sdk.database.domain.MomentsReviewNotification;
import com.xdja.moments.sdk.database.domain.NewCommentsNotification;
import com.xdja.moments.sdk.database.domain.NewMomentsNotification;
import com.xdja.moments.sdk.flow.main.mvp.ClassifyListModel;
import com.xdja.moments.sdk.flow.main.mvp.MomentConfigModel;
import com.xdja.moments.sdk.flow.main.mvp.MomentPowerModel;
import com.xdja.moments.sdk.manager.MomentsManager;
import com.xdja.moments.sdk.repository.MomentsClassifyRepository;
import com.xdja.moments.sdk.repository.MomentsConfigRepository;
import com.xdja.moments.sdk.repository.MomentsPowerRepository;
import com.xdja.moments.sdk.repository.MomentsReviewRepository;
import com.xdja.moments.sdk.repository.NewCommentsRepository;
import com.xdja.moments.sdk.repository.NewMomentsRepository;
import com.xdja.moments.sdk.utils.MomentsRxTransformer;
import io.reactivex.disposables.Disposable;

public class MomentsNotificationManager {
    private static MomentsNotificationManager mInstance;

    private MomentsNotificationManager() {
    }

    public static synchronized MomentsNotificationManager getInstance() {
        if (null == mInstance) {
            mInstance = new MomentsNotificationManager();
        }
        return mInstance;
    }

    public void addMomentNotification(MomentNotification notification) {
        switch (notification.getNotificationType()) {
            case 1: {
                this.onConfigChanged();
                break;
            }
            case 2: {
                this.onPermissionChanged();
                break;
            }
            case 4: {
                NewCommentsNotification newCommentsNotification = new NewCommentsNotification();
                newCommentsNotification.setMomentsId(notification.getMomentId());
                newCommentsNotification.setCreateTime(notification.getCreateTime());
                newCommentsNotification.setCommentId(notification.getCommentId());
                newCommentsNotification.setClassifyId(notification.getClassifyId());
                newCommentsNotification.setCommentUserId(notification.getCommentUserId());
                this.onNewComment(newCommentsNotification);
                break;
            }
            case 5: {
                NewMomentsNotification newMomentsNotification = new NewMomentsNotification();
                newMomentsNotification.setClassifyId(notification.getClassifyId());
                newMomentsNotification.setCreateTime(notification.getCreateTime());
                newMomentsNotification.setMomentsId(notification.getMomentId());
                this.onNewMoments(newMomentsNotification);
                break;
            }
            case 3: {
                MomentsReviewNotification momentsReviewNotification = new MomentsReviewNotification();
                momentsReviewNotification.setCreateTime(notification.getCreateTime());
                momentsReviewNotification.setMomentsId(notification.getMomentId());
                momentsReviewNotification.setType(notification.getReviewType());
                momentsReviewNotification.setClassifyId(notification.getClassifyId());
                this.onNewReview(momentsReviewNotification);
                break;
            }
            default: {
                Logger.d((Object)"\u540e\u53f0\u4f20\u5165\u901a\u77e5\u7c7b\u578b\u6709\u8bef");
            }
        }
    }

    private void onNewMoments(NewMomentsNotification newMomentsNotification) {
        Disposable subscribe = new NewMomentsRepository().insert(newMomentsNotification).subscribe(aBoolean -> Logger.d((Object)"\u63d2\u5165\u65b0\u5de5\u4f5c\u5708\u6210\u529f"), throwable -> Logger.d((Object)("\u63d2\u5165\u65b0\u5de5\u4f5c\u5708\u5931\u8d25\n" + throwable.getMessage())));
    }

    private void onNewComment(NewCommentsNotification newCommentsNotification) {
        Disposable subscribe = new NewCommentsRepository().insert(newCommentsNotification).subscribe(aBoolean -> Logger.d((Object)"\u63d2\u65b0\u8bc4\u8bba\u6210\u529f"), throwable -> Logger.d((Object)("\u63d2\u65b0\u8bc4\u8bba\u5931\u8d25:" + throwable.getMessage())));
    }

    private void onNewReview(MomentsReviewNotification reviewNotification) {
        Disposable subscribe = new MomentsReviewRepository().insert(reviewNotification).subscribe(aBoolean -> Logger.d((Object)"\u63d2\u5165\u5ba1\u6838\u6570\u636e\u6210\u529f"), throwable -> Logger.d((Object)"\u63d2\u5165\u5ba1\u6838\u6570\u636e\u5931\u8d25"));
    }

    private void onPermissionChanged() {
        BaseParams baseParams = new BaseParams();
        MomentPowerModel powerModel = new MomentPowerModel();
        ClassifyListModel classifyModel = new ClassifyListModel();
        Disposable powerSubscribe = powerModel.getMomentPower(baseParams).compose(MomentsRxTransformer.momentsCompose(baseParams)).map(momentsPower -> {
            momentsPower.setUserId(MomentsManager.getInstance().getLoginer().getUserId());
            MomentsPowerRepository momentsPowerRepository = new MomentsPowerRepository();
            momentsPowerRepository.clearAsync();
            momentsPowerRepository.insertAsync(momentsPower);
            return true;
        }).compose(ObservableTransfor.io_main()).subscribe(aBoolean -> Logger.d((Object)"\u63d2\u5165\u6743\u9650\u6570\u636e\u6210\u529f"), throwable -> Logger.d((Object)("\u63d2\u5165\u6743\u9650\u6570\u636e\u5931\u8d25:" + throwable.getMessage())));
        Disposable classifySubscribe = classifyModel.getClassifyList(baseParams).compose(MomentsRxTransformer.momentsCompose(baseParams)).map(momentsClassify -> {
            MomentsClassifyRepository momentsClassifyRepository = new MomentsClassifyRepository();
            momentsClassifyRepository.clearAsync();
            momentsClassifyRepository.insertAsync(momentsClassify);
            return true;
        }).compose(ObservableTransfor.io_main()).subscribe(aBoolean -> Logger.d((Object)"\u63d2\u5165\u5206\u7c7b\u6570\u636e\u6210\u529f"), throwable -> Logger.d((Object)("\u63d2\u5165\u5206\u7c7b\u6570\u636e\u5931\u8d25:" + throwable.getMessage())));
    }

    private void onConfigChanged() {
        BaseParams baseParams = new BaseParams();
        Disposable subscribe = new MomentConfigModel().getMomentConfig(baseParams).compose(MomentsRxTransformer.momentsCompose(baseParams)).map(momentsConfig -> {
            momentsConfig.setUserId(MomentsManager.getInstance().getLoginer().getUserId());
            MomentsConfigRepository momentsConfigRepository = new MomentsConfigRepository();
            momentsConfigRepository.clearAsync();
            momentsConfigRepository.insertAsync(momentsConfig);
            return true;
        }).compose(ObservableTransfor.io_main()).subscribe(aBoolean -> Logger.d((Object)"\u63d2\u5165\u914d\u7f6e\u6570\u636e\u6210\u529f"), throwable -> Logger.d((Object)"\u63d2\u5165\u914d\u7f6e\u6570\u636e\u5931\u8d25"));
    }
}

