/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.repository;

import com.xdja.baselibrary.rx.MaybeTransfor;
import com.xdja.moments.sdk.database.dao.BaseDao;
import com.xdja.moments.sdk.database.dao.MomentsClassifyDao;
import com.xdja.moments.sdk.database.db.MomentsRoomDatabase;
import com.xdja.moments.sdk.database.domain.MomentsClassify;
import com.xdja.moments.sdk.repository.BaseRepository;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import java.util.List;

public class MomentsClassifyRepository
extends BaseRepository<MomentsClassify> {
    private MomentsClassifyDao classifyDao;

    public MomentsClassifyRepository() {
        MomentsRoomDatabase momentsRoomDatabase = MomentsRoomDatabase.getDatabase();
        this.classifyDao = momentsRoomDatabase.momentsClassifyDao();
    }

    public Flowable<List<MomentsClassify>> getClassifyList() {
        return this.classifyDao.getMomentsClassify();
    }

    public Flowable<List<MomentsClassify>> getCanPublishClassifyList() {
        return this.classifyDao.getCanPublishMomentsClassify();
    }

    public Flowable<MomentsClassify> getClassify(String classIfyId) {
        return this.classifyDao.getMomentsClassify(classIfyId);
    }

    public Maybe<Boolean> clear() {
        return Maybe.create(emitter -> {
            this.classifyDao.deleteAll();
            emitter.onSuccess((Object)true);
        }).compose(MaybeTransfor.io_main());
    }

    public void clearAsync() {
        this.classifyDao.deleteAll();
    }

    @Override
    BaseDao<MomentsClassify> getDao() {
        return this.classifyDao;
    }
}

