/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.repository;

import android.support.annotation.NonNull;
import com.xdja.baselibrary.rx.MaybeTransfor;
import com.xdja.moments.sdk.database.dao.BaseDao;
import com.xdja.moments.sdk.database.dao.NewMomentsDao;
import com.xdja.moments.sdk.database.db.MomentsRoomDatabase;
import com.xdja.moments.sdk.database.domain.NewMomentsNotification;
import com.xdja.moments.sdk.repository.BaseRepository;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import java.util.List;

public class NewMomentsRepository
extends BaseRepository<NewMomentsNotification> {
    private NewMomentsDao newMomentsDao;

    public NewMomentsRepository() {
        MomentsRoomDatabase momentsRoomDatabase = MomentsRoomDatabase.getDatabase();
        this.newMomentsDao = momentsRoomDatabase.momentsDao();
    }

    public Flowable<Integer> getNewMomentsCount() {
        return this.newMomentsDao.getNewMomentsCount();
    }

    public Flowable<List<String>> getNewMomentClasifyId() {
        return this.newMomentsDao.getNewMomentClassify();
    }

    public Flowable<Integer> getNewMomentsCount(String classifyId) {
        return this.newMomentsDao.getNewMomentsCount(classifyId);
    }

    public Maybe<Boolean> clear() {
        return Maybe.create(emitter -> {
            this.newMomentsDao.deleteAll();
            emitter.onSuccess((Object)true);
        }).compose(MaybeTransfor.io_main());
    }

    public void clearAsync() {
        this.newMomentsDao.deleteAll();
    }

    public Maybe<Boolean> clear(String classifyId) {
        return Maybe.create(emitter -> {
            this.newMomentsDao.deleteNewMomentsByClassify(classifyId);
            emitter.onSuccess((Object)true);
        }).compose(MaybeTransfor.io_main());
    }

    public void clearAsync(String classifyId) {
        this.newMomentsDao.deleteNewMomentsByClassify(classifyId);
    }

    @Override
    @NonNull
    BaseDao<NewMomentsNotification> getDao() {
        return this.newMomentsDao;
    }
}

