/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Environment;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ImageSpan;
import android.util.Base64;
import android.util.Log;
import com.xdja.baselibrary.media.AppendixBean;
import com.xdja.baselibrary.util.FileUtils;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.utils.ImageCache;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BitmapUtils {
    private static final int itemh = 360;
    private static final int itemw = 360;
    private static final int miniMapMaxSize = 8192;
    private static final int scaleSize = 102400;
    private static String fileFolder = Environment.getExternalStorageDirectory().getPath() + "/moments/file_scale/";
    public static List<String> emojiList;

    public static void startPhotoZoom(Uri uri, Activity context, int requestCode) {
        Intent intent = new Intent("com.android.camera.action.CROP");
        intent.setDataAndType(uri, "image/*");
        intent.putExtra("crop", "true");
        intent.putExtra("aspectX", 1);
        intent.putExtra("aspectY", 1);
        intent.putExtra("outputX", 360);
        intent.putExtra("outputY", 360);
        intent.putExtra("return-data", true);
        context.startActivityForResult(intent, requestCode);
    }

    public static Bitmap big(Bitmap bitmap) {
        Matrix matrix = new Matrix();
        matrix.postScale(1.5f, 1.5f);
        Bitmap resizeBmp = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        return resizeBmp;
    }

    public static String getMiniMap2(Bitmap scaleBitmap) {
        int yScale;
        int scaleFactor;
        Log.e((String)"sendPicture", (String)(System.currentTimeMillis() + "\u56fe\u7247\u7f29\u7565\u56fe\u5f00\u59cb"));
        if (scaleBitmap == null) {
            return "";
        }
        int xScale = scaleBitmap.getWidth() / 360;
        int n = scaleFactor = xScale > (yScale = scaleBitmap.getHeight() / 360) ? xScale : yScale;
        if (scaleFactor <= 0) {
            scaleFactor = 1;
        }
        scaleBitmap = Bitmap.createScaledBitmap((Bitmap)scaleBitmap, (int)(scaleBitmap.getWidth() / scaleFactor), (int)(scaleBitmap.getHeight() / scaleFactor), (boolean)false);
        return BitmapUtils.getBitmapBase64Str(scaleBitmap);
    }

    public static Bitmap small(Bitmap bitmap, float scale) {
        Matrix matrix = new Matrix();
        matrix.postScale(scale, scale);
        Bitmap resizeBmp = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        return resizeBmp;
    }

    public static Bitmap getBitmapWithName(String fieldName, Resources resource) throws NoSuchFieldException, NumberFormatException, IllegalArgumentException, IllegalAccessException {
        Field field = R.drawable.class.getDeclaredField(fieldName);
        int resouseId = Integer.parseInt(field.get(null).toString());
        return BitmapFactory.decodeResource((Resources)resource, (int)resouseId);
    }

    public static SpannableString formatSpanContent(CharSequence sourceContent, Context context, float smallScall) throws NumberFormatException, IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        if (TextUtils.isEmpty((CharSequence)sourceContent)) {
            return null;
        }
        SpannableString spannableString = new SpannableString(sourceContent);
        String emoStr = "";
        String emoStrCache = "";
        Pattern pattern = Pattern.compile("(\\[emoji_[0-9]{3}\\])");
        Matcher matcher = pattern.matcher(sourceContent);
        while (matcher.find()) {
            emoStr = matcher.group(1);
            if (!BitmapUtils.getEmojiList().contains(emoStr)) continue;
            emoStr = emoStr.substring(1, emoStr.length() - 1);
            ImageCache imageCache = ImageCache.getInstance();
            Bitmap bitmap = null;
            emoStrCache = emoStr + smallScall;
            if (imageCache.get(emoStrCache) != null) {
                bitmap = imageCache.get(emoStrCache);
            } else {
                bitmap = BitmapUtils.getBitmapWithName(emoStr, context.getResources());
                bitmap = BitmapUtils.small(bitmap, smallScall);
                imageCache.put(emoStrCache, bitmap);
            }
            ImageSpan span = new ImageSpan(context, bitmap);
            spannableString.setSpan((Object)span, matcher.start(), matcher.end(), 33);
        }
        return spannableString;
    }

    public static List<String> getEmojiList() {
        if (emojiList == null) {
            emojiList = new ArrayList<String>();
            for (int i = 0; i < 72; ++i) {
                emojiList.add("[emoji_" + String.format("%03d", i + 1) + "]");
            }
        }
        return emojiList;
    }

    public static SpannableString formatSpanContentAdapter(String sourceContent, Context context) throws NumberFormatException, IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        if (TextUtils.isEmpty((CharSequence)sourceContent)) {
            return null;
        }
        SpannableString spannableString = new SpannableString((CharSequence)sourceContent);
        String emoStr = "";
        Pattern pattern = Pattern.compile("(\\[emoji_[0-9]{3}\\])");
        Matcher matcher = pattern.matcher(sourceContent);
        while (matcher.find()) {
            emoStr = matcher.group(1);
            emoStr = emoStr.substring(1, emoStr.length() - 1);
            Bitmap bitmap = BitmapUtils.getBitmapWithName(emoStr, context.getResources());
            bitmap = BitmapUtils.small(bitmap, Float.parseFloat(context.getResources().getString(R.string.moments_faceitem_small)));
            ImageSpan span = new ImageSpan(context, bitmap);
            spannableString.setSpan((Object)span, matcher.start(), matcher.end(), 33);
        }
        return spannableString;
    }

    public static Bitmap Bytes2Bimap(byte[] b) {
        if (b.length != 0) {
            return BitmapFactory.decodeByteArray((byte[])b, (int)0, (int)b.length);
        }
        return null;
    }

    public static byte[] Bitmap2Bytes(Bitmap bm) {
        return BitmapUtils.Bitmap2Bytes(bm, 100);
    }

    public static byte[] Bitmap2Bytes(Bitmap bm, int level) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bm.compress(Bitmap.CompressFormat.JPEG, level, (OutputStream)baos);
        return baos.toByteArray();
    }

    public static Bitmap getZoomedDrawable(String filePath, int zoom) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        int mWidth = options.outWidth;
        int mHeight = options.outHeight;
        int s = 1;
        while (mWidth / s > 720 * zoom || mHeight / s > 720 * zoom) {
            s *= 2;
        }
        options = new BitmapFactory.Options();
        options.inSampleSize = s;
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
        options.inJustDecodeBounds = false;
        Bitmap bm = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        if (bm != null) {
            float fs;
            int h = bm.getHeight();
            int w = bm.getWidth();
            float ft = (float)w / (float)h;
            int neww = ft >= (fs = 1.0f) ? 360 * zoom : (int)((float)(360 * zoom) * ft);
            int newh = ft >= fs ? (int)((float)(360 * zoom) / ft) : 360 * zoom;
            float scaleWidth = (float)neww / (float)w;
            float scaleHeight = (float)newh / (float)h;
            Matrix matrix = new Matrix();
            matrix.postScale(scaleWidth, scaleHeight);
            bm = Bitmap.createBitmap((Bitmap)bm, (int)0, (int)0, (int)w, (int)h, (Matrix)matrix, (boolean)true);
            return bm;
        }
        return null;
    }

    public static Bitmap getCircleBitmap(Bitmap bitmap) {
        Bitmap output = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        int color2 = -12434878;
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-12434878);
        int x = bitmap.getWidth();
        canvas.drawCircle((float)(x / 2), (float)(x / 2), (float)(x / 2), paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);
        return output;
    }

    public static Bitmap getBitmap(String path, int width, int heigh) {
        if (!FileUtils.isFileExist((String)path)) {
            return null;
        }
        try {
            BitmapFactory.Options op = new BitmapFactory.Options();
            op.inJustDecodeBounds = true;
            Bitmap bt = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)op);
            int xScale = op.outWidth / width;
            int yScale = op.outHeight / heigh;
            op.inSampleSize = xScale > yScale ? xScale : yScale;
            op.inJustDecodeBounds = false;
            bt = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)op);
            return bt;
        }
        catch (Exception e) {
            if (e != null) {
                e.printStackTrace();
            }
            Log.e((String)"Test", (String)("\u52a0\u8f7d\u56fe\u7247\u5931\u8d25 exception e : " + e.getMessage()));
            return null;
        }
    }

    public static String compPicture(String path) {
        Log.e((String)"sendPicture", (String)(System.currentTimeMillis() + "\u538b\u7f29\u56fe\u7247\u5f00\u59cb"));
        String fileName = FileUtils.getFileName((String)path);
        BitmapFactory.Options newOpts = new BitmapFactory.Options();
        newOpts.inJustDecodeBounds = true;
        Bitmap bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)newOpts);
        newOpts.inJustDecodeBounds = false;
        int w = newOpts.outWidth;
        int h = newOpts.outHeight;
        float hh = 960.0f;
        float ww = 540.0f;
        int be = 1;
        if (w > h && (float)w > ww) {
            be = (int)((float)newOpts.outWidth / ww);
        } else if (w < h && (float)h > hh) {
            be = (int)((float)newOpts.outHeight / hh);
        }
        if (be <= 0) {
            be = 1;
        }
        newOpts.inSampleSize = be;
        try {
            bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)newOpts);
        }
        catch (Exception e) {
            Log.e((String)"tag", (String)("\u538b\u7f29\u51fa\u9519\uff1a" + e.getMessage()));
        }
        if (bitmap == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)baos);
        int options = 100;
        while (baos.toByteArray().length / 1024 > 100) {
            baos.reset();
            if ((options -= 10) < 0) {
                options = 50;
            }
            bitmap.compress(Bitmap.CompressFormat.JPEG, options, (OutputStream)baos);
        }
        FileUtils.byte2File((byte[])baos.toByteArray(), (String)fileFolder, (String)fileName);
        if (bitmap != null && !bitmap.isRecycled()) {
            try {
                bitmap.recycle();
                bitmap = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Log.e((String)"sendPicture", (String)(System.currentTimeMillis() + "\u538b\u7f29\u56fe\u7247\u7ed3\u675f:" + fileFolder + fileName));
        return fileFolder + fileName;
    }

    public static String getBitmapBase64Str(Bitmap miniMap) {
        String miniMapStr_Base64 = "";
        int curCompressLevel = 100;
        if (null == miniMap) {
            return "";
        }
        byte[] curMiniMapBytes = BitmapUtils.Bitmap2Bytes(miniMap, curCompressLevel);
        if (curMiniMapBytes.length > 8192) {
            byte[] lastMiniMapBytes = curMiniMapBytes;
            byte[] lastButOneMiniMapBytes = null;
            int maxCompressLevel = 99;
            int minCompressLevel = 1;
            int lastCompressLevel = curCompressLevel;
            int tempCompressLevel = 0;
            curCompressLevel = 100 - 819200 / curMiniMapBytes.length;
            curCompressLevel = curCompressLevel == lastCompressLevel ? curCompressLevel - 1 : curCompressLevel;
            curMiniMapBytes = BitmapUtils.Bitmap2Bytes(miniMap, curCompressLevel);
            while (Math.abs(curCompressLevel - lastCompressLevel) > 1 && curMiniMapBytes.length != 8192) {
                lastButOneMiniMapBytes = lastMiniMapBytes;
                lastMiniMapBytes = curMiniMapBytes;
                tempCompressLevel = curCompressLevel;
                if (curMiniMapBytes.length > 8192) {
                    maxCompressLevel = curCompressLevel;
                    curCompressLevel = curCompressLevel > lastCompressLevel ? (curCompressLevel -= (curCompressLevel - lastCompressLevel) / 2) : minCompressLevel + (curCompressLevel - minCompressLevel) / 2;
                } else {
                    minCompressLevel = curCompressLevel;
                    curCompressLevel = curCompressLevel > lastCompressLevel ? maxCompressLevel - (maxCompressLevel - curCompressLevel) / 2 : (curCompressLevel += (lastCompressLevel - curCompressLevel) / 2);
                }
                if (curCompressLevel == (lastCompressLevel = tempCompressLevel)) continue;
                curMiniMapBytes = BitmapUtils.Bitmap2Bytes(miniMap, curCompressLevel);
            }
            miniMapStr_Base64 = curMiniMapBytes.length > 8192 && lastMiniMapBytes.length > 8192 ? (null != lastButOneMiniMapBytes ? Base64.encodeToString((byte[])lastButOneMiniMapBytes, (int)2) : Base64.encodeToString((byte[])curMiniMapBytes, (int)0)) : (curMiniMapBytes.length < 8192 && lastMiniMapBytes.length < 8192 ? Base64.encodeToString((byte[])curMiniMapBytes, (int)2) : (curMiniMapBytes.length > 8192 ? Base64.encodeToString((byte[])lastMiniMapBytes, (int)2) : Base64.encodeToString((byte[])curMiniMapBytes, (int)2)));
            lastMiniMapBytes = null;
            lastButOneMiniMapBytes = null;
        } else {
            miniMapStr_Base64 = Base64.encodeToString((byte[])curMiniMapBytes, (int)0);
        }
        curMiniMapBytes = null;
        Log.e((String)"sendPicture", (String)(System.currentTimeMillis() + "\u56fe\u7247\u7f29\u7565\u56fe\u7ed3\u675f"));
        return miniMapStr_Base64;
    }

    public static String getMiniMap(String pictureFilePath) {
        Log.e((String)"sendPicture", (String)(System.currentTimeMillis() + "\u56fe\u7247\u7f29\u7565\u56fe\u5f00\u59cb"));
        Bitmap miniMap = BitmapUtils.getBitmap(pictureFilePath, 360, 360);
        if (miniMap == null) {
            return "";
        }
        return BitmapUtils.getBitmapBase64Str(miniMap);
    }

    public static Bitmap drawableToBitmap(Drawable drawable2) {
        int width = drawable2.getIntrinsicWidth();
        int height = drawable2.getIntrinsicHeight();
        Bitmap.Config config = drawable2.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, width, height);
        drawable2.draw(canvas);
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String compPicture2(String path, AppendixBean bean) {
        Log.e((String)"sendPicture", (String)(System.currentTimeMillis() + "\u538b\u7f29\u56fe\u7247\u5f00\u59cb"));
        String fileName = FileUtils.getFileName((String)path);
        BitmapFactory.Options newOpts = new BitmapFactory.Options();
        newOpts.inJustDecodeBounds = true;
        Bitmap bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)newOpts);
        newOpts.inJustDecodeBounds = false;
        int w = newOpts.outWidth;
        int h = newOpts.outHeight;
        float hh = 1920.0f;
        float ww = 1080.0f;
        int be = 1;
        if (w > h && (float)w > ww) {
            be = (int)((float)newOpts.outWidth / ww);
        }
        if (be <= 0) {
            be = 1;
        }
        newOpts.inSampleSize = be;
        bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)newOpts);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)baos);
        int options = 100;
        while (baos.toByteArray().length / 1024 > 500) {
            baos.reset();
            if ((options -= 10) < 30) {
                options = 30;
            }
            bitmap.compress(Bitmap.CompressFormat.JPEG, options, (OutputStream)baos);
            if (options != 30) continue;
        }
        FileUtils.byte2File((byte[])baos.toByteArray(), (String)fileFolder, (String)fileName);
        if (bitmap != null && !bitmap.isRecycled()) {
            try {
                bitmap.recycle();
                bitmap = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Bitmap bmp = BitmapFactory.decodeByteArray((byte[])baos.toByteArray(), (int)0, (int)baos.toByteArray().length);
        bean.setMiniMap(BitmapUtils.getMiniMap2(bmp));
        if (bmp != null && !bmp.isRecycled()) {
            try {
                bmp.recycle();
                bmp = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != baos) {
            baos.reset();
            try {
                baos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                baos = null;
            }
        }
        Log.e((String)"sendPicture", (String)(System.currentTimeMillis() + "\u538b\u7f29\u56fe\u7247\u7ed3\u675f"));
        return fileFolder + fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String saveBitmap(Bitmap bitmap, String fileFolder) {
        File file = new File(fileFolder);
        if (!file.exists()) {
            file.mkdirs();
        }
        OutputStream outputStream = null;
        String filePath = null;
        try {
            filePath = fileFolder + System.currentTimeMillis() + ".png";
            outputStream = new FileOutputStream(new File(filePath));
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, outputStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.flush();
                    ((FileOutputStream)outputStream).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return filePath;
    }

    public static int[] getImageWidthHeight(String path) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        Bitmap bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        return new int[]{options.outWidth, options.outHeight};
    }
}

