/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    public static final String DATE_TYPE_YYYY_MM_DD = "yyyy-MM-dd";
    public static final String DATE_TYPE_YYYY_MM = "yyyy-MM";
    public static final String DATE_TYPE_YYYYMMDD = "yyyyMMdd";
    public static final String DATE_TYPE_YYYYMM = "yyyyMM";
    private static final int DAY = 86400;
    private static final int HOUR = 3600;
    private static final int MINUTE = 60;

    public static String getDateByMonth(Date date) {
        SimpleDateFormat sm = new SimpleDateFormat(DATE_TYPE_YYYY_MM_DD);
        return sm.format(date);
    }

    public static String getDateByMonth(Date date, String format) {
        SimpleDateFormat sm = new SimpleDateFormat(format);
        return sm.format(date);
    }

    public static String getDateByMonth(String date, String format) {
        SimpleDateFormat sm = new SimpleDateFormat(format);
        return sm.format(DateUtil.getString2Date(date, format));
    }

    public static Date getString2Date(String date, String format) {
        SimpleDateFormat sp = new SimpleDateFormat(format);
        Date spdate = null;
        try {
            spdate = sp.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return spdate;
    }

    public static long getUnixStamp() {
        return System.currentTimeMillis() / 1000L;
    }

    public static String getYestoryDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_TYPE_YYYY_MM_DD);
        String yestoday = sdf.format(calendar.getTime());
        return yestoday;
    }

    public static String getTodayDate() {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_TYPE_YYYY_MM_DD);
        String date = sdf.format(new Date());
        return date;
    }

    public static String timeStampToStr(long timeStamp) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = sdf.format(timeStamp * 1000L);
        return date;
    }

    public static String formatDate(long timeStamp) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_TYPE_YYYY_MM_DD);
        String date = sdf.format(timeStamp * 1000L);
        return date;
    }

    public static String getTime(long timeStamp) {
        String time = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = sdf.format(timeStamp * 1000L);
        String[] split = date.split("\\s");
        if (split.length > 1) {
            time = split[1];
        }
        return time;
    }

    public static String convertTimeToFormat(long timeStamp) {
        long curTime = System.currentTimeMillis() / 1000L;
        long time = curTime - timeStamp;
        if (time < 60L && time >= 0L) {
            return "\u521a\u521a";
        }
        if (time >= 60L && time < 3600L) {
            return time / 60L + "\u5206\u949f\u524d";
        }
        if (time >= 3600L && time < 86400L) {
            return time / 3600L + "\u5c0f\u65f6\u524d";
        }
        if (time >= 86400L && time < 2592000L) {
            return time / 3600L / 24L + "\u5929\u524d";
        }
        if (time >= 2592000L && time < 31104000L) {
            return time / 3600L / 24L / 30L + "\u4e2a\u6708\u524d";
        }
        if (time >= 31104000L) {
            return time / 3600L / 24L / 30L / 12L + "\u5e74\u524d";
        }
        return "\u521a\u521a";
    }

    public static String timeStampToFormat(long timeStamp) {
        long curTime = System.currentTimeMillis() / 1000L;
        long time = curTime - timeStamp;
        return time / 60L + "";
    }

    public static boolean isCloseEnough(long timeStamp1, long timeStamp2) {
        return (timeStamp1 - timeStamp2) / 1000L < 180L;
    }

    public static String getTimestampForList(Date date) {
        String todySDF = "HH:mm";
        String yesterDaySDF = "\u6628\u5929";
        String otherSDF = "M\u6708d\u65e5";
        String weekSDF = "E";
        SimpleDateFormat sfd = null;
        String time = "";
        Calendar dateCalendar = Calendar.getInstance();
        dateCalendar.setTime(date);
        Date now = new Date();
        Calendar targetCalendar = Calendar.getInstance();
        targetCalendar.setTime(now);
        targetCalendar.set(11, 0);
        targetCalendar.set(12, 0);
        if (dateCalendar.after(targetCalendar)) {
            sfd = new SimpleDateFormat(todySDF);
            time = sfd.format(date);
            return time;
        }
        targetCalendar.add(5, -1);
        if (dateCalendar.after(targetCalendar)) {
            sfd = new SimpleDateFormat(yesterDaySDF);
            time = sfd.format(date);
            return time;
        }
        Calendar mondayCalendar = Calendar.getInstance();
        mondayCalendar.set(7, 2);
        if (dateCalendar.compareTo(mondayCalendar) >= 0 && dateCalendar.compareTo(targetCalendar) < 0) {
            sfd = new SimpleDateFormat(weekSDF);
            time = sfd.format(date);
            return time;
        }
        if (date.getTime() == 0L) {
            return "\u6b63\u5728\u52a0\u8f7d\u2026\u2026";
        }
        sfd = new SimpleDateFormat(otherSDF);
        time = sfd.format(date);
        return time;
    }

    public static String getTimestampString(Date date, boolean hasHourMin) {
        String todySDF = "HH:mm";
        String yesterDaySDF = "\u6628\u5929 HH:mm";
        String otherSDF = "M\u6708d\u65e5";
        String weekSDF = "E HH:mm";
        if (hasHourMin) {
            otherSDF = "M\u6708d\u65e5 HH:mm";
        }
        SimpleDateFormat sfd = null;
        String time = "";
        Calendar dateCalendar = Calendar.getInstance();
        dateCalendar.setTime(date);
        Date now = new Date();
        Calendar targetCalendar = Calendar.getInstance();
        targetCalendar.setTime(now);
        targetCalendar.set(11, 0);
        targetCalendar.set(12, 0);
        if (dateCalendar.after(targetCalendar)) {
            sfd = new SimpleDateFormat(todySDF);
            time = sfd.format(date);
            return time;
        }
        targetCalendar.add(5, -1);
        if (dateCalendar.after(targetCalendar)) {
            sfd = new SimpleDateFormat(yesterDaySDF);
            time = sfd.format(date);
            return time;
        }
        Calendar mondayCalendar = Calendar.getInstance();
        mondayCalendar.set(7, 2);
        if (dateCalendar.compareTo(mondayCalendar) >= 0 && dateCalendar.compareTo(targetCalendar) < 0) {
            sfd = new SimpleDateFormat(weekSDF);
            time = sfd.format(date);
            return time;
        }
        if (date.getTime() == 0L) {
            return "\u6b63\u5728\u52a0\u8f7d\u2026\u2026";
        }
        sfd = new SimpleDateFormat(otherSDF);
        time = sfd.format(date);
        return time;
    }

    public static String getTimeStringFromNow(long timestamp) {
        long currentTime = System.currentTimeMillis();
        long timeGap = (currentTime - timestamp) / 1000L;
        String timeStr = null;
        timeStr = timeGap > 86400L ? DateUtil.getSimpleDate(new Date(timestamp)) : (timeGap > 3600L ? timeGap / 3600L + "\u5c0f\u65f6\u524d" : (timeGap > 60L ? timeGap / 60L + "\u5206\u949f\u524d" : "\u521a\u521a"));
        return timeStr;
    }

    public static long getTimeLong(String sTime) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = sdf.parse(sTime);
        return date.getTime();
    }

    public static String getSimpleDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_TYPE_YYYY_MM_DD);
        String time = sdf.format(date);
        return time;
    }

    public static String getLongToDateString(long time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        return sdf.format(new Date(time));
    }

    public static String getFastDfsTs() {
        return String.valueOf(System.currentTimeMillis() + 600000L);
    }
}

