/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ImageSpan;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.utils.BitmapUtils;
import java.util.ArrayList;
import java.util.List;

public class EmojiUtil {
    public static final int EMOJI_UNITE_LENGTH = 11;
    private static List<String> emojiList;

    public static List<String> getEmojiList() {
        if (emojiList == null) {
            emojiList = new ArrayList<String>();
            for (int i = 0; i < 72; ++i) {
                emojiList.add("[emoji_" + String.format("%03d", i + 1) + "]");
            }
        }
        return emojiList;
    }

    public static void showKeyboard(View view) {
        ((InputMethodManager)view.getContext().getSystemService("input_method")).showSoftInput(view, 1);
    }

    public static void hidKeyboard(View view) {
        ((InputMethodManager)view.getContext().getSystemService("input_method")).hideSoftInputFromWindow(view.getWindowToken(), 2);
    }

    public static SpannableString getSpannableStr(Context context, int facesPos) throws NoSuchFieldException, NumberFormatException, IllegalArgumentException, IllegalAccessException {
        Bitmap bitmap = BitmapUtils.getBitmapWithName("emoji_" + String.format("%03d", facesPos), context.getResources());
        bitmap = BitmapUtils.small(bitmap, Float.parseFloat(context.getResources().getString(R.string.moments_faceitem_small)));
        ImageSpan is = new ImageSpan(context, bitmap);
        String cs = "[emoji_" + String.format("%03d", facesPos) + "]";
        SpannableString ss = new SpannableString((CharSequence)cs);
        ss.setSpan((Object)is, 0, cs.length(), 33);
        return ss;
    }

    public static void deleteSpannableStr(EditText editText) {
        String content;
        int cursonIndex = editText.getSelectionStart();
        int leftIndex = 0;
        if (cursonIndex > 0 && !TextUtils.isEmpty((CharSequence)(content = editText.getText().toString()))) {
            int rightIndex = (content = content.substring(0, cursonIndex)).lastIndexOf("]");
            if (rightIndex != -1 && rightIndex == content.length() - 1 && (leftIndex = content.lastIndexOf("[")) != -1) {
                String temp = content.substring(leftIndex, rightIndex + 1);
                if (EmojiUtil.getEmojiList().contains(temp)) {
                    editText.getEditableText().delete(leftIndex, cursonIndex);
                    return;
                }
            }
            leftIndex = cursonIndex - 1;
            editText.getEditableText().delete(leftIndex, cursonIndex);
        }
    }
}

