/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.utils;

import android.annotation.SuppressLint;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.storage.StorageManager;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.text.TextUtils;
import com.xdja.moments.sdk.utils.IOUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class GetPathFromUri4kitkat {
    public static final String fileFolder = Environment.getExternalStorageDirectory().getPath() + "/jingxin/.cache/share_file/";
    private static final Pattern DIR_SEPARATOR = Pattern.compile("/");

    @SuppressLint(value={"NewApi"})
    public static String getPath(Context context, Uri uri) {
        boolean isKitKat = Build.VERSION.SDK_INT >= 19;
        String path = null;
        if (isKitKat && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (GetPathFromUri4kitkat.isExternalStorageDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                if ("primary".equalsIgnoreCase(type)) {
                    path = Environment.getExternalStorageDirectory() + "/" + split[1];
                } else {
                    String tmp = GetPathFromUri4kitkat.getStoragePath(context, true);
                    if (!TextUtils.isEmpty((CharSequence)tmp)) {
                        path = tmp + "/" + split[1];
                    }
                }
            } else if (GetPathFromUri4kitkat.isDownloadsDocument(uri)) {
                String id2 = DocumentsContract.getDocumentId((Uri)uri);
                if (id2.startsWith("raw:")) {
                    path = id2.substring(4);
                } else {
                    Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(id2));
                    path = GetPathFromUri4kitkat.getDataColumn(context, contentUri, null, null);
                }
            } else if (GetPathFromUri4kitkat.isMediaDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                Uri contentUri = null;
                if ("image".equals(type)) {
                    contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                } else if ("video".equals(type)) {
                    contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                } else if ("audio".equals(type)) {
                    contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                }
                String selection = "_id=?";
                String[] selectionArgs = new String[]{split[1]};
                path = GetPathFromUri4kitkat.getDataColumn(context, contentUri, "_id=?", selectionArgs);
            }
        } else if ("content".equalsIgnoreCase(uri.getScheme())) {
            path = GetPathFromUri4kitkat.getDataColumn(context, uri, null, null);
        } else if ("file".equalsIgnoreCase(uri.getScheme())) {
            path = uri.getPath();
        }
        if (Build.VERSION.SDK_INT >= 24 && path == null) {
            path = GetPathFromUri4kitkat.getQRCode(context, uri);
        }
        return path;
    }

    private static String getStoragePath(Context mContext, boolean is_removale) {
        StorageManager mStorageManager = (StorageManager)mContext.getSystemService("storage");
        Class<?> storageVolumeClazz = null;
        try {
            storageVolumeClazz = Class.forName("android.os.storage.StorageVolume");
            Method getVolumeList = mStorageManager.getClass().getMethod("getVolumeList", new Class[0]);
            Method getPath = storageVolumeClazz.getMethod("getPath", new Class[0]);
            Method isRemovable = storageVolumeClazz.getMethod("isRemovable", new Class[0]);
            Object result = getVolumeList.invoke((Object)mStorageManager, new Object[0]);
            int length = Array.getLength(result);
            for (int i = 0; i < length; ++i) {
                Object storageVolumeElement = Array.get(result, i);
                String path = (String)getPath.invoke(storageVolumeElement, new Object[0]);
                boolean removable = (Boolean)isRemovable.invoke(storageVolumeElement, new Object[0]);
                if (is_removale != removable) continue;
                return path;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static List<String> getStorageDirectories() {
        ArrayList<String> rv = new ArrayList<String>();
        String rawExternalStorage = System.getenv("EXTERNAL_STORAGE");
        String rawSecondaryStoragesStr = System.getenv("SECONDARY_STORAGE");
        String rawEmulatedStorageTarget = System.getenv("EMULATED_STORAGE_TARGET");
        if (TextUtils.isEmpty((CharSequence)rawEmulatedStorageTarget)) {
            if (TextUtils.isEmpty((CharSequence)rawExternalStorage)) {
                rv.add("/storage/sdcard0");
            } else {
                rv.add(rawExternalStorage);
            }
        } else {
            String rawUserId;
            if (Build.VERSION.SDK_INT < 17) {
                rawUserId = "";
            } else {
                String path = Environment.getExternalStorageDirectory().getAbsolutePath();
                String[] folders = DIR_SEPARATOR.split(path);
                String lastFolder = folders[folders.length - 1];
                boolean isDigit = false;
                try {
                    Integer.valueOf(lastFolder);
                    isDigit = true;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                String string2 = rawUserId = isDigit ? lastFolder : "";
            }
            if (TextUtils.isEmpty((CharSequence)rawUserId)) {
                rv.add(rawEmulatedStorageTarget);
            } else {
                rv.add(rawEmulatedStorageTarget + File.separator + rawUserId);
            }
        }
        if (!TextUtils.isEmpty((CharSequence)rawSecondaryStoragesStr)) {
            String[] rawSecondaryStorages = rawSecondaryStoragesStr.split(File.pathSeparator);
            Collections.addAll(rv, rawSecondaryStorages);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getQRCode(Context context, Uri uri) {
        String result;
        String displayName = uri.getLastPathSegment();
        File mainFile = new File(fileFolder);
        if (!mainFile.exists()) {
            mainFile.mkdirs();
        }
        if (new File(result = fileFolder + System.currentTimeMillis() + "_" + displayName).exists()) {
            return result;
        }
        InputStream is = null;
        FileOutputStream os = null;
        try {
            is = context.getContentResolver().openInputStream(uri);
            if (is == null) {
                String string2 = null;
                return string2;
            }
            int available = is.available();
            byte[] buf = new byte[available];
            int read = is.read(buf);
            if (read != -1) {
                os = new FileOutputStream(result);
                os.write(buf);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{"_data"};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int column_index = cursor.getColumnIndexOrThrow("_data");
                String string2 = cursor.getString(column_index);
                IOUtils.closeQuietly(cursor);
                return string2;
            }
            IOUtils.closeQuietly(cursor);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(cursor);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRealPathFromURI(Context context, Uri contentUri) {
        String res = null;
        String[] proj = new String[]{"_data"};
        Cursor cursor = null;
        try {
            cursor = context.getContentResolver().query(contentUri, proj, null, null, null);
            if (null != cursor && cursor.moveToFirst()) {
                int column_index = cursor.getColumnIndexOrThrow("_data");
                res = cursor.getString(column_index);
            }
            IOUtils.closeQuietly(cursor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(cursor);
        }
        return res;
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }
}

