/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.utils;

import com.orhanobut.logger.Logger;
import com.xdja.baselibrary.base.BaseParams;
import com.xdja.baselibrary.constant.MomentsConstants;
import com.xdja.baselibrary.exception.ServerException;
import com.xdja.baselibrary.rx.HttpErrorFunc;
import com.xdja.baselibrary.rx.ObservableTransfor;
import com.xdja.baselibrary.rx.ServerResponseFunc;
import com.xdja.moments.sdk.flow.login.mvp.LoginModel;
import com.xdja.moments.sdk.http.bean.request.LoginParams;
import com.xdja.moments.sdk.http.bean.response.LoginResponseBean;
import com.xdja.moments.sdk.manager.MomentsManager;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Function;
import java.util.concurrent.TimeUnit;

public class MomentsRetryWithTime
implements Function<Observable<Throwable>, ObservableSource<?>> {
    private final int maxTryCount;
    private final int retryDelayMillis;
    private int retryCount;
    private BaseParams baseParams;

    public MomentsRetryWithTime(BaseParams baseParams, int maxTryCount, int retryDelayMillis) {
        this.maxTryCount = maxTryCount;
        this.retryDelayMillis = retryDelayMillis;
        this.retryCount = 0;
        this.baseParams = baseParams;
    }

    public ObservableSource<?> apply(Observable<Throwable> throwableObservable) {
        return throwableObservable.flatMap(throwable -> {
            if (++this.retryCount <= this.maxTryCount && throwable instanceof ServerException) {
                if (((ServerException)throwable).code == 40000 || ((ServerException)throwable).code == 40001) {
                    Logger.d((Object)"Session\u8d85\u65f6\u6216\u4e0d\u5b58\u5728\uff0c\u6b63\u5728\u91cd\u65b0\u83b7\u53d6");
                    LoginParams loginParams = MomentsManager.getInstance().getLoginParams();
                    new LoginModel().login(loginParams).compose(ObservableTransfor.io_main()).map((Function)new ServerResponseFunc()).map(LoginResponseBean::getAuthorization).onErrorResumeNext((Function)new HttpErrorFunc()).subscribe((Observer)new Observer<String>(){

                        public void onSubscribe(Disposable d) {
                        }

                        public void onNext(String stringBaseResult) {
                            Logger.d((Object)("\u65b0session\uff1a" + stringBaseResult));
                            MomentsConstants.AUTHORIZATION = stringBaseResult;
                            MomentsRetryWithTime.this.baseParams.setAuthorization(stringBaseResult);
                        }

                        public void onError(Throwable e) {
                        }

                        public void onComplete() {
                        }
                    });
                    return Observable.timer((long)this.retryDelayMillis, (TimeUnit)TimeUnit.MILLISECONDS);
                }
                return Observable.error((Throwable)throwable);
            }
            return Observable.error((Throwable)throwable);
        });
    }
}

