/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.text.TextUtils;
import android.widget.Toast;
import com.xdja.moments.sdk.bean.share.BaseShareBean;
import com.xdja.moments.sdk.bean.share.ShareFileBean;
import com.xdja.moments.sdk.bean.share.ShareImageBean;
import com.xdja.moments.sdk.bean.share.ShareVideoBean;
import com.xdja.moments.sdk.manager.FileTypeManager;
import java.io.Serializable;
import java.util.List;

public class PublishShareUtil {
    public static BaseShareBean convertToShareBean(String content, String filePath) {
        BaseShareBean result;
        if (TextUtils.isEmpty((CharSequence)content) && TextUtils.isEmpty((CharSequence)filePath)) {
            return new BaseShareBean();
        }
        if (!TextUtils.isEmpty((CharSequence)filePath)) {
            FileTypeManager.FileType fileType = PublishShareUtil.getFileType(filePath);
            if (fileType != null) {
                switch (fileType) {
                    case IMAGE: {
                        ShareImageBean result2 = new ShareImageBean();
                        result2.setPath(filePath);
                        return result2;
                    }
                    case VIDEO: {
                        ShareVideoBean result3 = new ShareVideoBean();
                        result3.setPath(filePath);
                        return result3;
                    }
                }
                result = new ShareFileBean();
                ((ShareFileBean)result).setPath(filePath);
                ((ShareFileBean)result).setResId(FileTypeManager.getFileIconRes(fileType));
            } else {
                result = new BaseShareBean();
            }
        } else {
            result = new BaseShareBean();
        }
        result.setContent(content);
        return result;
    }

    private static FileTypeManager.FileType getFileType(String filePath) {
        return FileTypeManager.getFileType(filePath);
    }

    public static void startApp(Context context, BaseShareBean shareBean) {
        Intent intent = PublishShareUtil.getStartIntentByActionLaunch(context);
        if (intent == null) {
            intent = PublishShareUtil.getStartIntentByActionMain(context);
        }
        if (intent == null) {
            Toast.makeText((Context)context, (CharSequence)"\u8be5\u5e94\u7528\u4e0d\u652f\u6301\u6253\u5f00", (int)0).show();
            return;
        }
        if (shareBean != null) {
            intent.putExtra("publish_share_bean", (Serializable)shareBean);
        }
        intent.addFlags(0x10000000);
        context.startActivity(intent);
    }

    private static Intent getStartIntentByActionLaunch(Context context) {
        return context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
    }

    private static Intent getStartIntentByActionMain(Context context) {
        PackageManager pm = context.getPackageManager();
        Intent intentQuery = new Intent("android.intent.action.MAIN");
        intentQuery.setPackage(context.getPackageName());
        List resolveInfos = pm.queryIntentActivities(intentQuery, 64);
        String activityName = "";
        for (int i = 0; i < resolveInfos.size(); ++i) {
            ResolveInfo resolveInfo = (ResolveInfo)resolveInfos.get(i);
            if (!resolveInfo.activityInfo.packageName.equals(context.getPackageName())) continue;
            activityName = resolveInfo.activityInfo.name;
            break;
        }
        if (!TextUtils.isEmpty((CharSequence)activityName)) {
            Intent intent = new Intent();
            intent.setClassName(context.getPackageName(), activityName);
            return intent;
        }
        return null;
    }
}

