/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.utils;

import android.app.Activity;
import android.graphics.Rect;
import android.os.Build;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;

public class SoftHideKeyBoardUtil {
    private View mChildOfContent;
    private int usableHeightPrevious;
    private FrameLayout.LayoutParams frameLayoutParams;
    private int contentHeight;
    private boolean isfirst = true;
    private int statusBarHeight = 20;

    public static void assistActivity(Activity activity) {
        new SoftHideKeyBoardUtil(activity);
    }

    private SoftHideKeyBoardUtil(Activity activity) {
        FrameLayout content = (FrameLayout)activity.findViewById(0x1020002);
        this.mChildOfContent = content.getChildAt(0);
        this.mChildOfContent.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (SoftHideKeyBoardUtil.this.isfirst) {
                    SoftHideKeyBoardUtil.this.contentHeight = SoftHideKeyBoardUtil.this.mChildOfContent.getHeight();
                    SoftHideKeyBoardUtil.this.isfirst = false;
                }
                SoftHideKeyBoardUtil.this.possiblyResizeChildOfContent();
            }
        });
        this.frameLayoutParams = (FrameLayout.LayoutParams)this.mChildOfContent.getLayoutParams();
    }

    private void possiblyResizeChildOfContent() {
        int usableHeightNow = this.computeUsableHeight();
        if (usableHeightNow != this.usableHeightPrevious) {
            int usableHeightSansKeyboard = this.mChildOfContent.getRootView().getHeight();
            int heightDifference = usableHeightSansKeyboard - usableHeightNow;
            this.frameLayoutParams.height = heightDifference > usableHeightSansKeyboard / 4 ? (Build.VERSION.SDK_INT >= 19 ? usableHeightSansKeyboard - heightDifference + this.statusBarHeight : usableHeightSansKeyboard - heightDifference) : this.contentHeight;
            this.mChildOfContent.requestLayout();
            this.usableHeightPrevious = usableHeightNow;
        }
    }

    private int computeUsableHeight() {
        Rect r = new Rect();
        this.mChildOfContent.getWindowVisibleDisplayFrame(r);
        return r.bottom;
    }

    public static void observeSoftKeyboard(Activity activity, final OnSoftKeyboardChangeListener listener) {
        final View decorView = activity.getWindow().getDecorView();
        decorView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){
            int previousKeyboardHeight = -1;

            public void onGlobalLayout() {
                Rect rect = new Rect();
                decorView.getWindowVisibleDisplayFrame(rect);
                int displayHeight = rect.bottom - rect.top;
                int height = decorView.getHeight();
                int keyboardHeight = height - displayHeight;
                if (this.previousKeyboardHeight != keyboardHeight) {
                    boolean hide = (double)displayHeight / (double)height > 0.8;
                    listener.onSoftKeyBoardChange(keyboardHeight, !hide);
                }
                this.previousKeyboardHeight = height;
            }
        });
    }

    public static interface OnSoftKeyboardChangeListener {
        public void onSoftKeyBoardChange(int var1, boolean var2);
    }
}

