/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.utils.spannable;

import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.text.method.BaseMovementMethod;
import android.text.method.Touch;
import android.text.style.BackgroundColorSpan;
import android.text.style.ClickableSpan;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.manager.MomentsManager;

public class CircleMovementMethod
extends BaseMovementMethod {
    public final String TAG = CircleMovementMethod.class.getSimpleName();
    private static final int DEFAULT_COLOR_ID = R.color.moments_transparent;
    private static final int DEFAULT_CLICKABLEA_COLOR_ID = R.color.moments_clickable_color;
    private int textViewBgColor;
    private int clickableSpanBgClor;
    private BackgroundColorSpan mBgSpan;
    private ClickableSpan[] mClickLinks;
    private boolean isPassToTv = true;

    public boolean isPassToTv() {
        return this.isPassToTv;
    }

    private void setPassToTv(boolean isPassToTv) {
        this.isPassToTv = isPassToTv;
    }

    public CircleMovementMethod() {
        this.textViewBgColor = MomentsManager.getInstance().getContext().getResources().getColor(DEFAULT_COLOR_ID);
        this.clickableSpanBgClor = MomentsManager.getInstance().getContext().getResources().getColor(DEFAULT_CLICKABLEA_COLOR_ID);
    }

    public CircleMovementMethod(int clickableSpanBgClor) {
        this.clickableSpanBgClor = clickableSpanBgClor;
        this.textViewBgColor = MomentsManager.getInstance().getContext().getResources().getColor(DEFAULT_COLOR_ID);
    }

    public CircleMovementMethod(int clickableSpanBgClor, int textViewBgColor) {
        this.textViewBgColor = textViewBgColor;
        this.clickableSpanBgClor = clickableSpanBgClor;
    }

    public boolean onTouchEvent(TextView widget, Spannable buffer, MotionEvent event) {
        int action = event.getAction();
        if (action == 0) {
            int x = (int)event.getX();
            int y = (int)event.getY();
            x -= widget.getTotalPaddingLeft();
            y -= widget.getTotalPaddingTop();
            Layout layout2 = widget.getLayout();
            int line = layout2.getLineForVertical(y += widget.getScrollY());
            int off = layout2.getOffsetForHorizontal(line, (float)(x += widget.getScrollX()));
            this.mClickLinks = (ClickableSpan[])buffer.getSpans(off, off, ClickableSpan.class);
            if (this.mClickLinks.length > 0) {
                this.setPassToTv(false);
                Selection.setSelection((Spannable)buffer, (int)buffer.getSpanStart((Object)this.mClickLinks[0]), (int)buffer.getSpanEnd((Object)this.mClickLinks[0]));
                this.mBgSpan = new BackgroundColorSpan(this.clickableSpanBgClor);
                buffer.setSpan((Object)this.mBgSpan, buffer.getSpanStart((Object)this.mClickLinks[0]), buffer.getSpanEnd((Object)this.mClickLinks[0]), 33);
            } else {
                this.setPassToTv(true);
                widget.setBackgroundColor(this.textViewBgColor);
            }
        } else if (action == 1) {
            if (this.mClickLinks.length > 0) {
                this.mClickLinks[0].onClick((View)widget);
                if (this.mBgSpan != null) {
                    buffer.removeSpan((Object)this.mBgSpan);
                }
            }
            Selection.removeSelection((Spannable)buffer);
            widget.setBackgroundResource(R.color.moments_transparent);
        } else if (action != 2) {
            if (this.mBgSpan != null) {
                buffer.removeSpan((Object)this.mBgSpan);
            }
            widget.setBackgroundResource(R.color.moments_transparent);
        }
        return Touch.onTouchEvent((TextView)widget, (Spannable)buffer, (MotionEvent)event);
    }
}

