/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.viewmodel;

import android.app.Application;
import android.arch.lifecycle.AndroidViewModel;
import android.arch.lifecycle.MutableLiveData;
import com.orhanobut.logger.Logger;
import com.xdja.baselibrary.rx.FlowableTransfor;
import com.xdja.moments.sdk.database.domain.MomentsClassify;
import com.xdja.moments.sdk.repository.MomentsClassifyRepository;
import io.reactivex.disposables.CompositeDisposable;
import java.util.List;

public class MomentsClassifyViewModel
extends AndroidViewModel {
    private MutableLiveData<MomentsClassify> momentsClassIfyMutableLiveData = new MutableLiveData();
    private MutableLiveData<List<MomentsClassify>> allClassifyLiveData = new MutableLiveData();
    private final CompositeDisposable disposables = new CompositeDisposable();
    private MomentsClassifyRepository momentsClassifyRepository = new MomentsClassifyRepository();

    public MomentsClassifyViewModel(Application application) {
        super(application);
        this.loadMomentsClassifies();
    }

    public MomentsClassifyViewModel(Application application, String classify) {
        super(application);
        this.loadMomentsClassify(classify);
    }

    private void loadMomentsClassify(String classifyId) {
        this.disposables.add(this.momentsClassifyRepository.getClassify(classifyId).compose(FlowableTransfor.io_main()).subscribe(arg_0 -> this.momentsClassIfyMutableLiveData.setValue(arg_0), t -> Logger.e((String)"get momentsClassify error", (Object[])new Object[0])));
    }

    private void loadMomentsClassifies() {
        this.disposables.add(this.momentsClassifyRepository.getClassifyList().compose(FlowableTransfor.io_main()).subscribe(arg_0 -> this.allClassifyLiveData.setValue(arg_0), t -> {
            t.printStackTrace();
            Logger.e((String)("get momentsClassify error:" + t.getMessage()), (Object[])new Object[0]);
        }));
    }

    public MutableLiveData<MomentsClassify> getMomentsClassIfy() {
        return this.momentsClassIfyMutableLiveData;
    }

    public MutableLiveData<List<MomentsClassify>> getAllMomentsClassIfy() {
        return this.allClassifyLiveData;
    }

    public void clearMomentsConfig() {
        this.disposables.add(this.momentsClassifyRepository.clear().subscribe(aBoolean -> Logger.d((Object)"\u6e05\u7a7a\u5de5\u4f5c\u5708\u5206\u7c7b\u6210\u529f"), throwable -> Logger.d((Object)"\u6e05\u7a7a\u5de5\u4f5c\u5708\u5206\u7c7b\u5931\u8d25")));
    }

    public void onCleared() {
        super.onCleared();
        this.disposables.clear();
    }
}

