/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.viewmodel;

import android.app.Application;
import android.arch.lifecycle.AndroidViewModel;
import android.arch.lifecycle.MutableLiveData;
import com.orhanobut.logger.Logger;
import com.xdja.baselibrary.rx.FlowableTransfor;
import com.xdja.moments.sdk.repository.MomentsReviewRepository;
import io.reactivex.disposables.CompositeDisposable;

public class MomentsReviewViewModel
extends AndroidViewModel {
    private MutableLiveData<Integer> allMomentsReviewCount = new MutableLiveData();
    private MutableLiveData<Integer> reviewFailCount = new MutableLiveData();
    private MutableLiveData<Integer> newReviewCount = new MutableLiveData();
    private final CompositeDisposable disposables = new CompositeDisposable();
    private MomentsReviewRepository momentsReviewRepository = new MomentsReviewRepository();

    private void loadAllMomentsReviewCount() {
        this.disposables.add(this.momentsReviewRepository.getMomentsReviewCount().compose(FlowableTransfor.io_main()).subscribe(arg_0 -> this.allMomentsReviewCount.setValue(arg_0), t -> Logger.e((String)("get Review error," + t.getMessage()), (Object[])new Object[0])));
    }

    private void loadReviewCountByType(String type, MutableLiveData<Integer> data) {
        this.disposables.add(this.momentsReviewRepository.getMomentsReviewCount(type).compose(FlowableTransfor.io_main()).subscribe(arg_0 -> data.setValue(arg_0), t -> Logger.e((String)("get Review error," + t.getMessage()), (Object[])new Object[0])));
    }

    public MomentsReviewViewModel(Application application) {
        super(application);
        this.loadAllMomentsReviewCount();
        this.loadReviewCountByType("reviewFail", this.reviewFailCount);
        this.loadReviewCountByType("reviewNew", this.newReviewCount);
    }

    public MutableLiveData<Integer> getReviewFailCount() {
        return this.reviewFailCount;
    }

    public MutableLiveData<Integer> getNewReviewCount() {
        return this.newReviewCount;
    }

    public MutableLiveData<Integer> getAllReviewCount() {
        return this.allMomentsReviewCount;
    }

    public void clearAllReview() {
        this.disposables.add(this.momentsReviewRepository.clear().subscribe(aBoolean -> Logger.d((Object)"\u6e05\u7a7a\u6240\u6709\u5ba1\u6838\u63a8\u9001\u6210\u529f"), throwable -> Logger.d((Object)("\u6e05\u7a7a\u6240\u6709\u5ba1\u6838\u63a8\u9001\u5931\u8d25" + throwable.getMessage()))));
    }

    public void removeReviewByType(String type) {
        this.disposables.add(this.momentsReviewRepository.removeMomentsReview(type).subscribe(aBoolean -> Logger.d((Object)("\u6e05\u7a7a\u6240\u6709\u5ba1\u6838\u63a8\u9001\u6210\u529f\uff1a" + type)), throwable -> Logger.d((Object)("\u6e05\u7a7a\u6240\u6709\u5ba1\u6838\u63a8\u9001\u5931\u8d25\uff1a" + type + throwable.getMessage()))));
    }

    public void onCleared() {
        super.onCleared();
        this.disposables.clear();
    }
}

