/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.method.MovementMethod;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.xdja.moments.sdk.Navigation;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.bean.CommentBean;
import com.xdja.moments.sdk.bean.UserInfoBean;
import com.xdja.moments.sdk.utils.DateUtil;
import com.xdja.moments.sdk.utils.UrlUtils;
import com.xdja.moments.sdk.utils.spannable.CircleMovementMethod;
import com.xdja.moments.sdk.utils.spannable.SpannableClickable;
import java.util.ArrayList;
import java.util.List;

public class CommentDetailListView
extends LinearLayout {
    private int itemColor;
    private int itemSelectorColor;
    private OnItemClickListener onItemClickListener;
    private OnItemLongClickListener onItemLongClickListener;
    private List<CommentBean> mDatas;
    private LayoutInflater layoutInflater;
    private Context mContext;

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    public void setOnItemLongClickListener(OnItemLongClickListener onItemLongClickListener) {
        this.onItemLongClickListener = onItemLongClickListener;
    }

    public void setDatas(List<CommentBean> datas) {
        if (datas == null) {
            datas = new ArrayList<CommentBean>();
        }
        this.mDatas = datas;
        this.notifyDataSetChanged();
    }

    public List<CommentBean> getDatas() {
        return this.mDatas;
    }

    public CommentDetailListView(Context context) {
        super(context);
        this.mContext = context;
    }

    public CommentDetailListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.initAttrs(attrs);
    }

    public CommentDetailListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.initAttrs(attrs);
    }

    protected void initAttrs(AttributeSet attrs) {
        TypedArray typedArray = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.MomentsCommentListView, 0, 0);
        try {
            this.itemColor = typedArray.getColor(R.styleable.MomentsCommentListView_moments_item_color, this.getResources().getColor(R.color.moments_text_blue));
            this.itemSelectorColor = typedArray.getColor(R.styleable.MomentsCommentListView_moments_item_selector_color, this.getResources().getColor(R.color.moments_clickable_color));
        }
        finally {
            typedArray.recycle();
        }
    }

    public void notifyDataSetChanged() {
        this.removeAllViews();
        if (this.mDatas == null || this.mDatas.size() == 0) {
            return;
        }
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        int i = 0;
        while (i < this.mDatas.size()) {
            int index;
            View view;
            if ((view = this.getView(index = i++)) == null) {
                throw new NullPointerException("listview item layout is null, please check getView()...");
            }
            this.addView(view, index, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    private View getView(int position) {
        String contentBodyStr;
        if (this.layoutInflater == null) {
            this.layoutInflater = LayoutInflater.from((Context)this.getContext());
        }
        View convertView = this.layoutInflater.inflate(R.layout.moments_detail_comment_item_layout, null, false);
        final CommentBean bean = this.mDatas.get(position);
        if (position + 1 == this.mDatas.size()) {
            convertView.findViewById(R.id.line).setVisibility(8);
        }
        ImageView mIvHead = (ImageView)convertView.findViewById(R.id.iv_head);
        TextView mTvName = (TextView)convertView.findViewById(R.id.tv_name);
        TextView mTvComment = (TextView)convertView.findViewById(R.id.tv_comment);
        TextView mTvCommentTime = (TextView)convertView.findViewById(R.id.tv_comment_time);
        final CircleMovementMethod circleMovementMethod = new CircleMovementMethod(this.itemSelectorColor, this.itemSelectorColor);
        UserInfoBean userInfoBean = bean.getUserInfo();
        Glide.with((Context)this.getContext()).load(userInfoBean.getUserAvatar()).placeholder(R.drawable.moments_person_default).error(R.drawable.moments_person_default).into(mIvHead);
        String name = userInfoBean.getUserName();
        if (TextUtils.isEmpty((CharSequence)name) || "null".equals(name)) {
            name = "\u5df2\u5220\u9664\u7684\u7528\u6237";
        }
        mTvName.setText((CharSequence)name);
        mTvCommentTime.setText((CharSequence)DateUtil.getTimeStringFromNow(bean.getCreateTime()));
        String id2 = bean.getUserInfo().getUserId();
        String toReplyName = "";
        if (bean.getToUserInfo() != null) {
            toReplyName = bean.getToUserInfo().getUserName();
        }
        SpannableStringBuilder builder = new SpannableStringBuilder();
        if (!TextUtils.isEmpty((CharSequence)toReplyName)) {
            builder.append((CharSequence)" \u56de\u590d ");
            builder.append((CharSequence)this.setClickableSpan(toReplyName, bean.getToUserInfo().getUserId()));
            builder.append((CharSequence)": ");
        }
        if (!TextUtils.isEmpty((CharSequence)(contentBodyStr = bean.getCommentContent()))) {
            builder.append((CharSequence)UrlUtils.formatUrlString(contentBodyStr));
        }
        mTvComment.setText((CharSequence)builder);
        mTvComment.setMovementMethod((MovementMethod)circleMovementMethod);
        mTvComment.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (circleMovementMethod.isPassToTv() && CommentDetailListView.this.onItemClickListener != null) {
                    CommentDetailListView.this.onItemClickListener.onItemClick(bean);
                }
            }
        });
        mTvComment.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (circleMovementMethod.isPassToTv()) {
                    if (CommentDetailListView.this.onItemLongClickListener != null) {
                        CommentDetailListView.this.onItemLongClickListener.onItemLongClick(bean);
                    }
                    return true;
                }
                return false;
            }
        });
        return convertView;
    }

    @NonNull
    private SpannableString setClickableSpan(String textStr, final String id2) {
        SpannableString subjectSpanText = new SpannableString((CharSequence)textStr);
        subjectSpanText.setSpan((Object)new SpannableClickable(this.itemColor){

            public void onClick(View widget) {
                Navigation.navigationPersonDetail(CommentDetailListView.this.mContext, id2);
            }
        }, 0, subjectSpanText.length(), 33);
        return subjectSpanText;
    }

    public static interface OnItemLongClickListener {
        public void onItemLongClick(CommentBean var1);
    }

    public static interface OnItemClickListener {
        public void onItemClick(CommentBean var1);
    }
}

