/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.widget;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.widget.GridLayout;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.xdja.moments.sdk.Navigation;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.bean.ImageBean;
import com.xdja.moments.sdk.utils.MomentImageUtil;
import java.util.ArrayList;
import java.util.List;

public class PictureGridLayout
extends GridLayout {
    private int pictureSize;
    ArrayList<ImageBean> pictureList;

    public PictureGridLayout(Context context) {
        super(context);
        this.initView(context);
    }

    public PictureGridLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    private void initView(Context context) {
        Activity activity = (Activity)context;
        WindowManager wm = activity.getWindowManager();
        int margin = (int)context.getResources().getDimension(R.dimen.moments_topic_gridphoto_leftmargin);
        int size = (int)context.getResources().getDimension(R.dimen.moments_topic_gridphoto_margin);
        this.pictureSize = (wm.getDefaultDisplay().getWidth() - 2 * margin - size) / 3;
        this.setRowCount(3);
    }

    public void setPictures(Context context, List<ImageBean> pictures) {
        this.removeAllViews();
        if (pictures == null) {
            this.setVisibility(8);
            return;
        }
        this.pictureList = (ArrayList)pictures;
        if (pictures.size() == 4) {
            this.setColumnCount(2);
        } else {
            this.setColumnCount(3);
        }
        switch (pictures.size()) {
            case 0: {
                this.setVisibility(8);
                break;
            }
            case 1: {
                this.setVisibility(0);
                View layout2 = LayoutInflater.from((Context)context).inflate(R.layout.moments_griditem_imageview, null);
                ImageView imageview = (ImageView)layout2.findViewById(R.id.imageview);
                this.addView(layout2);
                this.setReSizeImage(context, layout2, imageview, pictures.get(0));
                imageview.setOnClickListener(arg0 -> this.intentToGallery(context, 0));
                break;
            }
            default: {
                this.setVisibility(0);
                int i = 0;
                while (i < pictures.size()) {
                    ImageBean imageBean = pictures.get(i);
                    View layout2 = LayoutInflater.from((Context)context).inflate(R.layout.moments_griditem_imageview, null);
                    ImageView imageviews = (ImageView)layout2.findViewById(R.id.imageview);
                    this.addView(layout2);
                    layout2.getLayoutParams().width = this.pictureSize;
                    layout2.getLayoutParams().height = this.pictureSize;
                    if (context == null || ((Activity)context).isFinishing() || Build.VERSION.SDK_INT >= 17 && ((Activity)context).isDestroyed()) {
                        return;
                    }
                    String thumbnailPath = MomentImageUtil.getThumbnail(imageBean.getPath(), this.pictureSize, this.pictureSize);
                    this.showImageSmall(context, thumbnailPath, imageviews);
                    int index = i++;
                    imageviews.setOnClickListener(arg0 -> this.intentToGallery(context, index));
                }
                break block0;
            }
        }
    }

    public void showImageSmall(Context context, String imagePath, ImageView imageview) {
        Glide.with((Context)context).load(imagePath).diskCacheStrategy(DiskCacheStrategy.ALL).placeholder(R.drawable.moments_img_pic_default).error(R.drawable.moments_img_pic_default).into(imageview);
    }

    private void intentToGallery(Context context, int index) {
        Navigation.navigationGallery(context, index, this.pictureList);
    }

    public void setReSizeImage(Context mContext, View layout2, ImageView iv, ImageBean imageBean) {
        int max_photo_width = (int)mContext.getResources().getDimension(R.dimen.moments_max_photo_width);
        int min_photo_width = (int)mContext.getResources().getDimension(R.dimen.moments_min_photo_width);
        int imageWith = imageBean.getWidth();
        int imageHeight = imageBean.getHeight();
        if (imageHeight < imageWith) {
            layout2.getLayoutParams().width = imageWith > max_photo_width ? max_photo_width : imageWith;
            layout2.getLayoutParams().height = imageHeight * layout2.getLayoutParams().width / imageWith;
        } else {
            layout2.getLayoutParams().height = imageHeight > max_photo_width ? max_photo_width : imageHeight;
            layout2.getLayoutParams().width = imageWith * layout2.getLayoutParams().height / imageHeight;
        }
        float scale = (float)layout2.getLayoutParams().height / (float)layout2.getLayoutParams().width;
        if (scale > 4.0f) {
            layout2.getLayoutParams().width = min_photo_width;
        } else if ((double)scale < 0.25) {
            layout2.getLayoutParams().height = min_photo_width;
        }
        String thumbnailPath = imageBean.getPath().endsWith(".jpg") ? MomentImageUtil.getThumbnail(imageBean.getPath(), layout2.getLayoutParams().width, layout2.getLayoutParams().height) : imageBean.getPath();
        this.showImageSmall(mContext, thumbnailPath, iv);
    }
}

