/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.widget;

import android.content.Context;
import android.graphics.Rect;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

public class RecyclerViewHeader
extends RelativeLayout {
    private int intendedVisibility = 0;
    private int downTranslation;
    private boolean hidden = false;
    private boolean recyclerWantsTouch;
    private boolean isVertical;
    private boolean isAttachedToRecycler;
    private RecyclerViewDelegate recyclerView;
    private LayoutManagerDelegate layoutManager;

    public RecyclerViewHeader(Context context) {
        super(context);
    }

    public RecyclerViewHeader(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public RecyclerViewHeader(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public final void attachTo(final @NonNull RecyclerView recycler) {
        this.validate(recycler);
        this.recyclerView = RecyclerViewDelegate.with(recycler);
        this.layoutManager = LayoutManagerDelegate.with(recycler.getLayoutManager());
        this.isVertical = this.layoutManager.isVertical();
        this.isAttachedToRecycler = true;
        this.recyclerView.setHeaderDecoration(new HeaderItemDecoration());
        this.recyclerView.setOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                RecyclerViewHeader.this.onScrollChanged();
            }
        });
        this.recyclerView.setOnChildAttachListener(new RecyclerView.OnChildAttachStateChangeListener(){

            public void onChildViewAttachedToWindow(View view) {
            }

            public void onChildViewDetachedFromWindow(View view) {
                recycler.post(new Runnable(){

                    @Override
                    public void run() {
                        RecyclerViewHeader.this.recyclerView.invalidateItemDecorations();
                        RecyclerViewHeader.this.onScrollChanged();
                    }
                });
            }
        });
    }

    public final void detach() {
        if (this.isAttachedToRecycler) {
            this.isAttachedToRecycler = false;
            this.recyclerWantsTouch = false;
            this.recyclerView.reset();
            this.recyclerView = null;
            this.layoutManager = null;
        }
    }

    private void onScrollChanged() {
        this.hidden = this.recyclerView.hasItems() && !this.layoutManager.isFirstRowVisible();
        RecyclerViewHeader.super.setVisibility(this.hidden ? 4 : this.intendedVisibility);
        if (!this.hidden) {
            int translation = this.calculateTranslation();
            if (this.isVertical) {
                this.setTranslationY(translation);
            } else {
                this.setTranslationX(translation);
            }
        }
    }

    private int calculateTranslation() {
        int offset = this.recyclerView.getScrollOffset(this.isVertical);
        int base = this.layoutManager.isReversed() ? this.recyclerView.getTranslationBase(this.isVertical) : 0;
        return base - offset;
    }

    public final void setVisibility(int visibility) {
        this.intendedVisibility = visibility;
        if (!this.hidden) {
            super.setVisibility(this.intendedVisibility);
        }
    }

    public final int getVisibility() {
        return this.intendedVisibility;
    }

    protected final void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (changed && this.isAttachedToRecycler) {
            int verticalMargins = 0;
            int horizontalMargins = 0;
            if (this.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.getLayoutParams();
                verticalMargins = layoutParams.topMargin + layoutParams.bottomMargin;
                horizontalMargins = layoutParams.leftMargin + layoutParams.rightMargin;
            }
            this.recyclerView.onHeaderSizeChanged(this.getHeight() + verticalMargins, this.getWidth() + horizontalMargins);
            this.onScrollChanged();
        }
    }

    @CallSuper
    public boolean onInterceptTouchEvent(MotionEvent ev) {
        boolean bl = this.recyclerWantsTouch = this.isAttachedToRecycler && this.recyclerView.onInterceptTouchEvent(ev);
        if (this.recyclerWantsTouch && ev.getAction() == 2) {
            this.downTranslation = this.calculateTranslation();
        }
        return this.recyclerWantsTouch || super.onInterceptTouchEvent(ev);
    }

    @CallSuper
    public boolean onTouchEvent(@NonNull MotionEvent event) {
        if (this.recyclerWantsTouch) {
            int scrollDiff = this.downTranslation - this.calculateTranslation();
            int verticalDiff = this.isVertical ? scrollDiff : 0;
            int horizontalDiff = this.isVertical ? 0 : scrollDiff;
            MotionEvent recyclerEvent = MotionEvent.obtain((long)event.getDownTime(), (long)event.getEventTime(), (int)event.getAction(), (float)(event.getX() - (float)horizontalDiff), (float)(event.getY() - (float)verticalDiff), (int)event.getMetaState());
            this.recyclerView.onTouchEvent(recyclerEvent);
            return false;
        }
        return super.onTouchEvent(event);
    }

    private void validate(RecyclerView recyclerView) {
        if (recyclerView.getLayoutManager() == null) {
            throw new IllegalStateException("Be sure to attach RecyclerViewHeader after setting your RecyclerView's LayoutManager.");
        }
    }

    private static class LayoutManagerDelegate {
        @Nullable
        private final LinearLayoutManager linear;
        @Nullable
        private final GridLayoutManager grid;
        @Nullable
        private final StaggeredGridLayoutManager staggeredGrid;

        private LayoutManagerDelegate(@NonNull RecyclerView.LayoutManager manager) {
            Class<?> managerClass = manager.getClass();
            if (managerClass == LinearLayoutManager.class) {
                this.linear = (LinearLayoutManager)manager;
                this.grid = null;
                this.staggeredGrid = null;
            } else if (managerClass == GridLayoutManager.class) {
                this.linear = null;
                this.grid = (GridLayoutManager)manager;
                this.staggeredGrid = null;
            } else {
                throw new IllegalArgumentException("Currently RecyclerViewHeader supports only LinearLayoutManager and GridLayoutManager.");
            }
        }

        public static LayoutManagerDelegate with(@NonNull RecyclerView.LayoutManager layoutManager) {
            return new LayoutManagerDelegate(layoutManager);
        }

        public final int getFirstRowSpan() {
            if (this.linear != null) {
                return 1;
            }
            if (this.grid != null) {
                return this.grid.getSpanCount();
            }
            return 0;
        }

        public final boolean isFirstRowVisible() {
            if (this.linear != null) {
                return this.linear.findFirstVisibleItemPosition() == 0;
            }
            if (this.grid != null) {
                return this.grid.findFirstVisibleItemPosition() == 0;
            }
            return false;
        }

        public final boolean isReversed() {
            if (this.linear != null) {
                return this.linear.getReverseLayout();
            }
            if (this.grid != null) {
                return this.grid.getReverseLayout();
            }
            return false;
        }

        public final boolean isVertical() {
            if (this.linear != null) {
                return this.linear.getOrientation() == 1;
            }
            if (this.grid != null) {
                return this.grid.getOrientation() == 1;
            }
            return false;
        }
    }

    private static class RecyclerViewDelegate {
        @NonNull
        private final RecyclerView recyclerView;
        private HeaderItemDecoration decoration;
        private RecyclerView.OnScrollListener onScrollListener;
        private RecyclerView.OnChildAttachStateChangeListener onChildAttachListener;

        private RecyclerViewDelegate(@NonNull RecyclerView recyclerView) {
            this.recyclerView = recyclerView;
        }

        public static RecyclerViewDelegate with(@NonNull RecyclerView recyclerView) {
            return new RecyclerViewDelegate(recyclerView);
        }

        public final void onHeaderSizeChanged(int height, int width) {
            if (this.decoration != null) {
                this.decoration.setHeight(height);
                this.decoration.setWidth(width);
                this.recyclerView.post(new Runnable(){

                    @Override
                    public void run() {
                        this.invalidateItemDecorations();
                    }
                });
            }
        }

        private void invalidateItemDecorations() {
            if (!this.recyclerView.isComputingLayout()) {
                this.recyclerView.invalidateItemDecorations();
            }
        }

        public final int getScrollOffset(boolean isVertical) {
            return isVertical ? this.recyclerView.computeVerticalScrollOffset() : this.recyclerView.computeHorizontalScrollOffset();
        }

        public final int getTranslationBase(boolean isVertical) {
            return isVertical ? this.recyclerView.computeVerticalScrollRange() - this.recyclerView.getHeight() : this.recyclerView.computeHorizontalScrollRange() - this.recyclerView.getWidth();
        }

        public final boolean hasItems() {
            return this.recyclerView.getAdapter() != null && this.recyclerView.getAdapter().getItemCount() != 0;
        }

        public final void setHeaderDecoration(HeaderItemDecoration decoration) {
            this.clearHeaderDecoration();
            this.decoration = decoration;
            this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)this.decoration, 0);
        }

        public final void clearHeaderDecoration() {
            if (this.decoration != null) {
                this.recyclerView.removeItemDecoration((RecyclerView.ItemDecoration)this.decoration);
                this.decoration = null;
            }
        }

        public final void setOnScrollListener(RecyclerView.OnScrollListener onScrollListener) {
            this.clearOnScrollListener();
            this.onScrollListener = onScrollListener;
            this.recyclerView.addOnScrollListener(this.onScrollListener);
        }

        public final void clearOnScrollListener() {
            if (this.onScrollListener != null) {
                this.recyclerView.removeOnScrollListener(this.onScrollListener);
                this.onScrollListener = null;
            }
        }

        public final void setOnChildAttachListener(RecyclerView.OnChildAttachStateChangeListener onChildAttachListener) {
            this.clearOnChildAttachListener();
            this.onChildAttachListener = onChildAttachListener;
            this.recyclerView.addOnChildAttachStateChangeListener(this.onChildAttachListener);
        }

        public final void clearOnChildAttachListener() {
            if (this.onChildAttachListener != null) {
                this.recyclerView.removeOnChildAttachStateChangeListener(this.onChildAttachListener);
                this.onChildAttachListener = null;
            }
        }

        public final void reset() {
            this.clearHeaderDecoration();
            this.clearOnScrollListener();
            this.clearOnChildAttachListener();
        }

        public boolean onInterceptTouchEvent(MotionEvent ev) {
            return this.recyclerView.onInterceptTouchEvent(ev);
        }

        public boolean onTouchEvent(MotionEvent ev) {
            return this.recyclerView.onTouchEvent(ev);
        }
    }

    private class HeaderItemDecoration
    extends RecyclerView.ItemDecoration {
        private int headerHeight;
        private int headerWidth;
        private int firstRowSpan;

        public HeaderItemDecoration() {
            this.firstRowSpan = RecyclerViewHeader.this.layoutManager.getFirstRowSpan();
        }

        public void setWidth(int width) {
            this.headerWidth = width;
        }

        public void setHeight(int height) {
            this.headerHeight = height;
        }

        public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
            int widthOffset;
            super.getItemOffsets(outRect, view, parent, state);
            boolean headerRelatedPosition = parent.getChildLayoutPosition(view) < this.firstRowSpan;
            int heightOffset = headerRelatedPosition && RecyclerViewHeader.this.isVertical ? this.headerHeight : 0;
            int n = widthOffset = headerRelatedPosition && !RecyclerViewHeader.this.isVertical ? this.headerWidth : 0;
            if (RecyclerViewHeader.this.layoutManager.isReversed()) {
                outRect.bottom = heightOffset;
                outRect.right = widthOffset;
            } else {
                outRect.top = heightOffset;
                outRect.left = widthOffset;
            }
        }
    }
}

