/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.widget.easemob;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.ListAdapter;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.widget.easemob.EaseEmojicon;
import com.xdja.moments.sdk.widget.easemob.EaseEmojiconGroupEntity;
import com.xdja.moments.sdk.widget.easemob.EmojiconGridAdapter;
import com.xdja.moments.sdk.widget.easemob.EmojiconPagerAdapter;
import java.util.ArrayList;
import java.util.List;

public class EaseEmojiconPagerView
extends ViewPager {
    private Context context;
    private List<EaseEmojiconGroupEntity> groupEntities;
    private PagerAdapter pagerAdapter;
    private int emojiconRows = 3;
    private int emojiconColumns = 7;
    private int bigEmojiconRows = 2;
    private int bigEmojiconColumns = 4;
    private int firstGroupPageSize;
    private int maxPageCount;
    private int previousPagerPosition;
    private EaseEmojiconPagerViewListener pagerViewListener;
    private List<View> viewpages;

    public EaseEmojiconPagerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
    }

    public EaseEmojiconPagerView(Context context) {
        this(context, null);
    }

    public void init(List<EaseEmojiconGroupEntity> emojiconGroupList, int emijiconColumns, int bigEmojiconColumns) {
        if (emojiconGroupList == null) {
            throw new RuntimeException("emojiconGroupList is null");
        }
        this.groupEntities = emojiconGroupList;
        this.emojiconColumns = emijiconColumns;
        this.bigEmojiconColumns = bigEmojiconColumns;
        this.viewpages = new ArrayList<View>();
        for (int i = 0; i < this.groupEntities.size(); ++i) {
            EaseEmojiconGroupEntity group = this.groupEntities.get(i);
            List<GridView> gridViews = this.getGroupGridViews(group);
            if (i == 0) {
                this.firstGroupPageSize = gridViews.size();
            }
            this.maxPageCount = Math.max(gridViews.size(), this.maxPageCount);
            this.viewpages.addAll(gridViews);
        }
        this.pagerAdapter = new EmojiconPagerAdapter(this.viewpages);
        this.setAdapter(this.pagerAdapter);
        this.setOnPageChangeListener(new EmojiPagerChangeListener());
        if (this.pagerViewListener != null) {
            this.pagerViewListener.onPagerViewInited(this.maxPageCount, this.firstGroupPageSize);
        }
    }

    public void setPagerViewListener(EaseEmojiconPagerViewListener pagerViewListener) {
        this.pagerViewListener = pagerViewListener;
    }

    public void setGroupPostion(int position) {
        if (this.getAdapter() != null && position >= 0 && position < this.groupEntities.size()) {
            int count = 0;
            for (int i = 0; i < position; ++i) {
                count += this.getPageSize(this.groupEntities.get(i));
            }
            this.setCurrentItem(count);
        }
    }

    private List<GridView> getGroupGridViews(EaseEmojiconGroupEntity groupEntity) {
        List<EaseEmojicon> emojiconList = groupEntity.getEmojiconList();
        int itemSize = this.emojiconColumns * this.emojiconRows - 1;
        int totalSize = emojiconList.size();
        EaseEmojicon.Type emojiType = groupEntity.getType();
        if (emojiType == EaseEmojicon.Type.BIG_EXPRESSION) {
            itemSize = this.bigEmojiconColumns * this.bigEmojiconRows;
        }
        int pageSize = totalSize % itemSize == 0 ? totalSize / itemSize : totalSize / itemSize + 1;
        ArrayList<GridView> views = new ArrayList<GridView>();
        for (int i = 0; i < pageSize; ++i) {
            GridView gv = new GridView(this.context);
            gv.setSelector((Drawable)new ColorDrawable(0));
            gv.setCacheColorHint(0);
            int item_space = (int)this.context.getResources().getDimension(R.dimen.moments_emotion_item_space);
            gv.setVerticalSpacing(item_space);
            gv.setGravity(17);
            gv.setNumColumns(emojiType == EaseEmojicon.Type.BIG_EXPRESSION ? this.bigEmojiconColumns : this.emojiconColumns);
            gv.setPadding(item_space, item_space, item_space, 0);
            ArrayList<EaseEmojicon> list = new ArrayList<EaseEmojicon>();
            if (i != pageSize - 1) {
                list.addAll(emojiconList.subList(i * itemSize, (i + 1) * itemSize));
            } else {
                list.addAll(emojiconList.subList(i * itemSize, totalSize));
            }
            if (emojiType != EaseEmojicon.Type.BIG_EXPRESSION) {
                EaseEmojicon deleteIcon = new EaseEmojicon();
                deleteIcon.setEmojiText("em_delete_delete_expression");
                list.add(deleteIcon);
            }
            final EmojiconGridAdapter gridAdapter = new EmojiconGridAdapter(this.context, 1, list, emojiType);
            gv.setAdapter((ListAdapter)gridAdapter);
            gv.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    EaseEmojicon emojicon = (EaseEmojicon)gridAdapter.getItem(position);
                    if (EaseEmojiconPagerView.this.pagerViewListener != null) {
                        String emojiText = emojicon.getEmojiText();
                        if (emojiText != null && emojiText.equals("em_delete_delete_expression")) {
                            EaseEmojiconPagerView.this.pagerViewListener.onDeleteImageClicked();
                        } else {
                            EaseEmojiconPagerView.this.pagerViewListener.onExpressionClicked(emojicon);
                        }
                    }
                }
            });
            views.add(gv);
        }
        return views;
    }

    public void addEmojiconGroup(EaseEmojiconGroupEntity groupEntity, boolean notifyDataChange) {
        int pageSize = this.getPageSize(groupEntity);
        if (pageSize > this.maxPageCount) {
            this.maxPageCount = pageSize;
            if (this.pagerViewListener != null && this.pagerAdapter != null) {
                this.pagerViewListener.onGroupMaxPageSizeChanged(this.maxPageCount);
            }
        }
        this.viewpages.addAll(this.getGroupGridViews(groupEntity));
        if (this.pagerAdapter != null && notifyDataChange) {
            this.pagerAdapter.notifyDataSetChanged();
        }
    }

    public void removeEmojiconGroup(int position) {
        if (position > this.groupEntities.size() - 1) {
            return;
        }
        if (this.pagerAdapter != null) {
            this.pagerAdapter.notifyDataSetChanged();
        }
    }

    private int getPageSize(EaseEmojiconGroupEntity groupEntity) {
        List<EaseEmojicon> emojiconList = groupEntity.getEmojiconList();
        int itemSize = this.emojiconColumns * this.emojiconRows - 1;
        int totalSize = emojiconList.size();
        EaseEmojicon.Type emojiType = groupEntity.getType();
        if (emojiType == EaseEmojicon.Type.BIG_EXPRESSION) {
            itemSize = this.bigEmojiconColumns * this.bigEmojiconRows;
        }
        int pageSize = totalSize % itemSize == 0 ? totalSize / itemSize : totalSize / itemSize + 1;
        return pageSize;
    }

    public static interface EaseEmojiconPagerViewListener {
        public void onPagerViewInited(int var1, int var2);

        public void onGroupPositionChanged(int var1, int var2);

        public void onGroupInnerPagePostionChanged(int var1, int var2);

        public void onGroupPagePostionChangedTo(int var1);

        public void onGroupMaxPageSizeChanged(int var1);

        public void onDeleteImageClicked();

        public void onExpressionClicked(EaseEmojicon var1);
    }

    private class EmojiPagerChangeListener
    implements ViewPager.OnPageChangeListener {
        private EmojiPagerChangeListener() {
        }

        public void onPageSelected(int position) {
            int endSize = 0;
            int groupPosition = 0;
            for (EaseEmojiconGroupEntity groupEntity : EaseEmojiconPagerView.this.groupEntities) {
                int groupPageSize = EaseEmojiconPagerView.this.getPageSize(groupEntity);
                if (endSize + groupPageSize > position) {
                    if (EaseEmojiconPagerView.this.previousPagerPosition - endSize < 0) {
                        if (EaseEmojiconPagerView.this.pagerViewListener == null) break;
                        EaseEmojiconPagerView.this.pagerViewListener.onGroupPositionChanged(groupPosition, groupPageSize);
                        EaseEmojiconPagerView.this.pagerViewListener.onGroupPagePostionChangedTo(0);
                        break;
                    }
                    if (EaseEmojiconPagerView.this.previousPagerPosition - endSize >= groupPageSize) {
                        if (EaseEmojiconPagerView.this.pagerViewListener == null) break;
                        EaseEmojiconPagerView.this.pagerViewListener.onGroupPositionChanged(groupPosition, groupPageSize);
                        EaseEmojiconPagerView.this.pagerViewListener.onGroupPagePostionChangedTo(position - endSize);
                        break;
                    }
                    if (EaseEmojiconPagerView.this.pagerViewListener == null) break;
                    EaseEmojiconPagerView.this.pagerViewListener.onGroupInnerPagePostionChanged(EaseEmojiconPagerView.this.previousPagerPosition - endSize, position - endSize);
                    break;
                }
                ++groupPosition;
                endSize += groupPageSize;
            }
            EaseEmojiconPagerView.this.previousPagerPosition = position;
        }

        public void onPageScrollStateChanged(int arg0) {
        }

        public void onPageScrolled(int arg0, float arg1, int arg2) {
        }
    }
}

