/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.widget.easemob;

import android.content.Context;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.xdja.moments.sdk.R;
import java.util.ArrayList;
import java.util.List;

public class EaseEmojiconScrollTabBar
extends RelativeLayout {
    private Context context;
    private HorizontalScrollView scrollView;
    private LinearLayout tabContainer;
    private List<ImageView> tabList = new ArrayList<ImageView>();
    private EaseScrollTabBarItemClickListener itemClickListener;
    private int tabWidth = 60;

    public EaseEmojiconScrollTabBar(Context context) {
        this(context, null);
    }

    public EaseEmojiconScrollTabBar(Context context, AttributeSet attrs, int defStyle) {
        this(context, attrs);
    }

    public EaseEmojiconScrollTabBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.context = context;
        LayoutInflater.from((Context)context).inflate(R.layout.moments_emotion_widget_tab_bar, (ViewGroup)this);
        this.scrollView = (HorizontalScrollView)this.findViewById(R.id.scroll_view);
        this.tabContainer = (LinearLayout)this.findViewById(R.id.tab_container);
    }

    public void addTab(int icon) {
        View tabView = View.inflate((Context)this.context, (int)R.layout.moments_emotion_scroll_tab_item, null);
        ImageView imageView = (ImageView)tabView.findViewById(R.id.iv_icon);
        imageView.setImageResource(icon);
        LinearLayout.LayoutParams imgParams = new LinearLayout.LayoutParams((int)((float)this.tabWidth * this.context.getResources().getDisplayMetrics().density + 0.5f), -1);
        imageView.setLayoutParams((ViewGroup.LayoutParams)imgParams);
        this.tabContainer.addView(tabView);
        this.tabList.add(imageView);
        final int position = this.tabList.size() - 1;
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (EaseEmojiconScrollTabBar.this.itemClickListener != null) {
                    EaseEmojiconScrollTabBar.this.itemClickListener.onItemClick(position);
                }
            }
        });
    }

    public void removeTab(int position) {
        this.tabContainer.removeViewAt(position);
        this.tabList.remove(position);
    }

    public void selectedTo(int position) {
        this.scrollTo(position);
        for (int i = 0; i < this.tabList.size(); ++i) {
            if (position == i) {
                this.tabList.get(i).setBackgroundColor(this.getResources().getColor(R.color.moments_gray_bg));
                continue;
            }
            this.tabList.get(i).setBackgroundColor(this.getResources().getColor(R.color.moments_text_gray));
        }
    }

    private void scrollTo(final int position) {
        int childCount = this.tabContainer.getChildCount();
        if (position < childCount) {
            this.scrollView.post(new Runnable(){

                @Override
                public void run() {
                    int hsvWidth;
                    int scrollRight;
                    int mScrollX = EaseEmojiconScrollTabBar.this.tabContainer.getScrollX();
                    int childX = (int)ViewCompat.getX((View)EaseEmojiconScrollTabBar.this.tabContainer.getChildAt(position));
                    if (childX < mScrollX) {
                        EaseEmojiconScrollTabBar.this.scrollView.scrollTo(childX, 0);
                        return;
                    }
                    int childWidth = EaseEmojiconScrollTabBar.this.tabContainer.getChildAt(position).getWidth();
                    int childRight = childX + childWidth;
                    if (childRight > (scrollRight = mScrollX + (hsvWidth = EaseEmojiconScrollTabBar.this.scrollView.getWidth()))) {
                        EaseEmojiconScrollTabBar.this.scrollView.scrollTo(childRight - scrollRight, 0);
                        return;
                    }
                }
            });
        }
    }

    public void setTabBarItemClickListener(EaseScrollTabBarItemClickListener itemClickListener) {
        this.itemClickListener = itemClickListener;
    }

    public static interface EaseScrollTabBarItemClickListener {
        public void onItemClick(int var1);
    }
}

