/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.widget.faceview;

import android.content.Context;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.widget.faceview.GridViewAdapter;
import com.xdja.moments.sdk.widget.faceview.ViewPageAdapter;
import java.util.ArrayList;
import java.util.List;

public class FaceGridView
extends LinearLayout {
    private Context _context;
    private ViewPager _viewPager;
    private LinearLayout _llDot;
    private OnFaceGridViewItemClick onFaceGridViewItemClick;
    private ImageView[] dots;
    private int currentIndex;
    private int viewPager_size;
    private double pageItemCount = 23.0;
    private List<GridView> list_Views;
    private int viewPageHeight = 380;
    private String backBtnName = "back_normal";
    public static final int emojSize = 72;
    private final int FACE_PAGE_SIZE = 23;
    private int viewpage_margin = 0;

    public FaceGridView(Context context) {
        super(context);
        this._context = context;
        this.initViewPage();
        this.initFootDots();
    }

    public FaceGridView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this._context = context;
        this.initViewPage();
        this.initFootDots();
    }

    private void initViewPage() {
        this.viewpage_margin = (int)this._context.getResources().getDimension(R.dimen.moments_faceitem_margin);
        this.setOrientation(1);
        this.setBackgroundColor(this._context.getResources().getColor(R.color.moments_white));
        this._viewPager = new ViewPager(this._context);
        this._viewPager.setOffscreenPageLimit(1);
        this._llDot = new LinearLayout(this._context);
        LinearLayout.LayoutParams ll = new LinearLayout.LayoutParams(-1, -1);
        ll.weight = 1.0f;
        ll.setMargins(0, this.viewpage_margin, 0, this.viewpage_margin);
        this._viewPager.setLayoutParams((ViewGroup.LayoutParams)ll);
        this._llDot.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this._llDot.setGravity(1);
        this._llDot.setOrientation(0);
        this.addView((View)this._viewPager);
        this.addView((View)this._llDot);
    }

    private void initFootDots() {
        int i;
        this.viewPager_size = (int)Math.ceil(72.0 / this.pageItemCount);
        if (0 < this.viewPager_size) {
            if (this.viewPager_size == 1) {
                this._llDot.setVisibility(8);
            } else {
                this._llDot.setVisibility(0);
                for (i = 0; i < this.viewPager_size; ++i) {
                    ImageView image = new ImageView(this._context);
                    image.setTag((Object)i);
                    LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(20, 20);
                    params.setMargins(16, 16, 16, 50);
                    image.setBackgroundResource(R.drawable.moments_dots_set);
                    image.setEnabled(false);
                    this._llDot.addView((View)image, (ViewGroup.LayoutParams)params);
                }
            }
        }
        if (1 != this.viewPager_size) {
            this.dots = new ImageView[this.viewPager_size];
            for (i = 0; i < this.viewPager_size; ++i) {
                this.dots[i] = (ImageView)this._llDot.getChildAt(i);
                this.dots[i].setEnabled(true);
                this.dots[i].setTag((Object)i);
            }
            this.currentIndex = 0;
            this.dots[this.currentIndex].setEnabled(false);
            this._viewPager.setOnPageChangeListener(new ViewPager.OnPageChangeListener(){

                public void onPageSelected(int arg0) {
                    FaceGridView.this.setCurDot(arg0 % FaceGridView.this.viewPager_size);
                }

                public void onPageScrolled(int arg0, float arg1, int arg2) {
                }

                public void onPageScrollStateChanged(int arg0) {
                }
            });
        }
    }

    private void setCurDot(int position) {
        if (position < 0 || position > this.viewPager_size - 1 || this.currentIndex == position) {
            return;
        }
        this.dots[position].setEnabled(false);
        this.dots[this.currentIndex].setEnabled(true);
        this.currentIndex = position;
    }

    public void setAdapter() {
        if (this.onFaceGridViewItemClick == null) {
            return;
        }
        this.list_Views = new ArrayList<GridView>();
        for (int i = 0; i < this.viewPager_size; ++i) {
            this.list_Views.add(this.getViewPagerItem(i));
        }
        this._viewPager.setAdapter((PagerAdapter)new ViewPageAdapter(this.list_Views));
    }

    private String[] getGridViewData(int index) {
        int startPos = (++index - 1) * 23;
        int endPos = index * 23;
        int length = 0;
        if (endPos > 72) {
            endPos = 72;
        }
        length = endPos - startPos + 1;
        String[] tmps = new String[length];
        int num = 0;
        for (int i = startPos; i < endPos; ++i) {
            tmps[num] = "emoji_" + String.format("%03d", i + 1);
            ++num;
        }
        tmps[length - 1] = this.backBtnName;
        return tmps;
    }

    private GridView getViewPagerItem(int index) {
        final GridView gridView = new GridView(this._context);
        gridView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        gridView.setPadding(this._context.getResources().getDimensionPixelSize(R.dimen.moments_6dp), this._context.getResources().getDimensionPixelSize(R.dimen.moments_20dp), this._context.getResources().getDimensionPixelSize(R.dimen.moments_6dp), 0);
        gridView.setNumColumns(8);
        gridView.setVerticalSpacing(this._context.getResources().getDimensionPixelSize(R.dimen.moments_12dp));
        gridView.setHorizontalSpacing(this._context.getResources().getDimensionPixelSize(R.dimen.moments_size_4));
        gridView.setSelector(R.drawable.moments_transparent);
        gridView.setVerticalScrollBarEnabled(false);
        gridView.setHorizontalScrollBarEnabled(false);
        gridView.setBackgroundColor(0);
        gridView.setAdapter((ListAdapter)new GridViewAdapter(this._context, this.getGridViewData(index)));
        gridView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (position == gridView.getChildCount() - 1) {
                    FaceGridView.this.onFaceGridViewItemClick.onClear();
                } else {
                    FaceGridView.this.onFaceGridViewItemClick.onItemClick(FaceGridView.this.currentIndex * 23 + position + 1);
                }
            }
        });
        return gridView;
    }

    public void setOnFaceGridViewItemClick(OnFaceGridViewItemClick onFaceGridViewItemClick) {
        this.onFaceGridViewItemClick = onFaceGridViewItemClick;
    }

    public static interface OnFaceGridViewItemClick {
        public void onItemClick(int var1);

        public void onClear();
    }
}

