/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.widget.faceview;

import android.content.Context;
import android.content.res.Resources;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.utils.BitmapUtils;

public class GridViewAdapter
extends BaseAdapter {
    private Context context;
    private String[] facesName;
    private Resources r;

    public GridViewAdapter(Context context, String[] facesName) {
        this.context = context;
        this.facesName = facesName;
        this.r = this.context.getResources();
    }

    public int getCount() {
        return this.facesName.length;
    }

    public Object getItem(int position) {
        return this.facesName[position];
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        GridViewHolder gridViewHolder = null;
        if (convertView == null) {
            gridViewHolder = new GridViewHolder();
            convertView = gridViewHolder.layoutView;
            convertView.setTag((Object)gridViewHolder);
        } else {
            gridViewHolder = (GridViewHolder)convertView.getTag();
        }
        try {
            gridViewHolder.faceIv.setImageBitmap(BitmapUtils.getBitmapWithName(this.facesName[position], this.context.getResources()));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return convertView;
    }

    public class GridViewHolder {
        public LinearLayout layoutView;
        public ImageView faceIv;

        public GridViewHolder() {
            AbsListView.LayoutParams layoutParams = new AbsListView.LayoutParams(GridViewAdapter.this.r.getDimensionPixelSize(R.dimen.moments_40dp), GridViewAdapter.this.r.getDimensionPixelSize(R.dimen.moments_40dp));
            this.layoutView = new LinearLayout(GridViewAdapter.this.context);
            this.layoutView.setBackgroundResource(R.drawable.moments_btn_emobj_bg_selector);
            this.faceIv = new ImageView(GridViewAdapter.this.context);
            this.layoutView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.layoutView.setOrientation(1);
            this.layoutView.setGravity(17);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
            this.faceIv.setLayoutParams((ViewGroup.LayoutParams)params);
            this.layoutView.addView((View)this.faceIv);
        }
    }
}

