/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.widget.input;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.support.v7.widget.AppCompatEditText;
import android.text.ClipboardManager;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ImageSpan;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Toast;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.manager.FaceManager;
import com.xdja.moments.sdk.widget.easemob.EaseEmojicon;
import com.xdja.moments.sdk.widget.input.AnimationYoYo;

public class EmotionEditText
extends AppCompatEditText {
    static final int PASTCODE = 0x1020022;
    int maxLength = 500;

    public EmotionEditText(Context context) {
        super(context);
    }

    public EmotionEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public EmotionEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public boolean onTextContextMenuItem(int id2) {
        switch (id2) {
            case 0x1020022: {
                ClipboardManager cmb = (ClipboardManager)this.getContext().getSystemService("clipboard");
                if (cmb == null || cmb.getText() == null) {
                    return false;
                }
                String tempstr = cmb.getText().toString();
                SpannableString ss = null;
                String preTxtStr = this.getText().toString();
                if (preTxtStr.length() >= this.maxLength) {
                    this.onOverFlowHint();
                    return false;
                }
                if (TextUtils.isEmpty((CharSequence)tempstr)) break;
                try {
                    tempstr = tempstr.length() > this.maxLength - preTxtStr.length() ? tempstr.substring(0, this.maxLength - preTxtStr.length()) : tempstr;
                    ss = (SpannableString)FaceManager.getInstance().convertNormalStringToSpannableString(this.getContext(), tempstr);
                    if (!TextUtils.isEmpty((CharSequence)ss)) {
                        this.getText().insert(this.getSelectionStart(), (CharSequence)ss);
                        this.setFocusable(true);
                        if (this.getText().toString().length() >= this.maxLength) {
                            this.onOverFlowHint();
                        }
                        return false;
                    }
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 0x1020021: {
                break;
            }
            case 0x1020020: {
                break;
            }
        }
        return super.onTextContextMenuItem(id2);
    }

    public void onOverFlowHint() {
        Toast.makeText((Context)this.getContext(), (CharSequence)this.getResources().getString(R.string.moments_add_text_over_hint), (int)0).show();
        AnimationYoYo.shakeView((View)this);
    }

    public void insertEmotion(Context context, EaseEmojicon emojicon) {
        if (this.getText() != null && emojicon.getEmojiText() != null && this.maxLength - this.getText().length() < emojicon.getEmojiText().length()) {
            this.onOverFlowHint();
            return;
        }
        int selectionStart = this.getSelectionStart();
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)emojicon.getIcon());
        int edittext_emojicon_size = (int)context.getResources().getDimension(R.dimen.moments_edittext_emojicon_size);
        if (bitmap != null) {
            int rawHeigh = bitmap.getHeight();
            int rawWidth = bitmap.getHeight();
            int newHeight = edittext_emojicon_size;
            int newWidth = edittext_emojicon_size;
            float heightScale = (float)newHeight / (float)rawHeigh;
            float widthScale = (float)newWidth / (float)rawWidth;
            Matrix matrix = new Matrix();
            matrix.postScale(heightScale, widthScale);
            Bitmap newBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)rawWidth, (int)rawHeigh, (Matrix)matrix, (boolean)true);
            ImageSpan imageSpan = new ImageSpan(context, newBitmap);
            bitmap.recycle();
            String emojiStr = emojicon.getEmojiText();
            SpannableString spannableString = new SpannableString((CharSequence)emojiStr);
            spannableString.setSpan((Object)imageSpan, emojiStr.indexOf(91), emojiStr.indexOf(93) + 1, 33);
            this.getEditableText().insert(selectionStart > 0 ? selectionStart : 0, (CharSequence)spannableString);
        }
    }

    public void onEmojiconDeleteEvent() {
        int selection = this.getSelectionStart();
        String text = this.getText().toString();
        if (selection > 0) {
            String tempStartString = text.substring(0, selection);
            if (tempStartString.endsWith("]")) {
                int start = tempStartString.lastIndexOf("[");
                int end = selection;
                this.getText().delete(start, end);
            } else {
                this.getText().delete(selection - 1, selection);
            }
        }
    }
}

