/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.widget.popwindow;

import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AppCompatActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.xdja.baselibrary.util.DensityUtil;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.viewmodel.MomentsReviewViewModel;

public class MomentsMainPop {
    private OnItemClickListener listener;
    private PopupWindow mPopupWindow;
    private AppCompatActivity context;
    private MomentsReviewViewModel momentsVm;
    private View parentView;
    private int[] windowPos;

    public MomentsMainPop(AppCompatActivity context, View parentView) {
        this.context = context;
        this.momentsVm = (MomentsReviewViewModel)ViewModelProviders.of((FragmentActivity)context).get(MomentsReviewViewModel.class);
        this.parentView = parentView;
        this.makePopupWindow();
    }

    public void show() {
        this.show(0, 0, -1);
    }

    public void show(int anim2) {
        this.show(0, 0, anim2);
    }

    public void show(int xOff, int yOff, int anim2) {
        if (anim2 != -1) {
            this.mPopupWindow.setAnimationStyle(anim2);
        }
        this.mPopupWindow.showAtLocation(this.parentView, 8388661, this.windowPos[0] + xOff, this.windowPos[1] + yOff);
    }

    public void hide() {
        this.mPopupWindow.dismiss();
    }

    public boolean isShowing() {
        return this.mPopupWindow.isShowing();
    }

    private void makePopupWindow() {
        View contentView = LayoutInflater.from((Context)this.context).inflate(R.layout.moments_main_pop, null);
        this.windowPos = this.calculatePopWindowPos(this.parentView, contentView);
        TextView myComments = (TextView)contentView.findViewById(R.id.tv_my_comments_count);
        TextView reviewComments = (TextView)contentView.findViewById(R.id.tv_review_momments_count);
        contentView.findViewById(R.id.ll_my_momments).setOnClickListener(view -> {
            if (this.listener != null) {
                this.hide();
                this.listener.onMyCommentsClick();
                this.momentsVm.removeReviewByType("reviewFail");
            }
        });
        contentView.findViewById(R.id.ll_review_momments).setOnClickListener(view -> {
            if (this.listener != null) {
                this.hide();
                this.listener.onReviewCommentsClick();
                this.momentsVm.removeReviewByType("reviewNew");
            }
        });
        this.momentsVm.getNewReviewCount().observe((LifecycleOwner)this.context, integer -> {
            if (integer > 0) {
                reviewComments.setVisibility(0);
                reviewComments.setText((CharSequence)(integer + ""));
            } else {
                reviewComments.setVisibility(8);
            }
        });
        this.momentsVm.getReviewFailCount().observe((LifecycleOwner)this.context, integer -> {
            if (integer > 0) {
                myComments.setVisibility(0);
                myComments.setText((CharSequence)(integer + ""));
            } else {
                myComments.setVisibility(8);
            }
        });
        this.mPopupWindow = new PopupWindow((Context)this.context);
        this.mPopupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        contentView.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        this.mPopupWindow.setContentView(contentView);
        this.mPopupWindow.setWidth(-2);
        this.mPopupWindow.setHeight(-2);
        this.mPopupWindow.setFocusable(true);
        this.mPopupWindow.setTouchable(true);
        this.mPopupWindow.setOutsideTouchable(true);
    }

    public void setOnItemClickLsitener(OnItemClickListener listener) {
        this.listener = listener;
    }

    private int[] calculatePopWindowPos(View anchorView, View contentView) {
        int[] windowPos = new int[2];
        int[] anchorLoc = new int[2];
        anchorView.getLocationOnScreen(anchorLoc);
        anchorView.measure(0, 0);
        int anchorViewWidth = anchorView.getMeasuredWidth();
        int anchorViewHeight = anchorView.getMeasuredHeight();
        windowPos[0] = anchorViewWidth / 2 - DensityUtil.dip2px((Context)this.context, (float)2.0f);
        windowPos[1] = anchorLoc[1] + anchorViewHeight;
        return windowPos;
    }

    public static interface OnItemClickListener {
        public void onMyCommentsClick();

        public void onReviewCommentsClick();
    }
}

