/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.widget.popwindow;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.v7.app.AppCompatActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.xdja.moments.sdk.R;

public class MyMomentsPop {
    private OnItemClickListener listener;
    private OnDisMissListener onDisMissListener;
    private PopupWindow mPopupWindow;
    private AppCompatActivity context;
    private View parentView;
    private int[] windowPos;

    public MyMomentsPop(AppCompatActivity context, View parentView) {
        this.context = context;
        this.parentView = parentView;
    }

    public void show() {
        this.show(0, 0, -1);
    }

    public void show(int anim2) {
        this.show(0, 0, anim2);
    }

    public void show(int xOff, int yOff, int anim2) {
        this.makePopupWindow();
        if (anim2 != -1) {
            this.mPopupWindow.setAnimationStyle(anim2);
        }
        this.mPopupWindow.showAsDropDown(this.parentView, this.windowPos[0] + xOff, 0);
    }

    public void hide() {
        this.mPopupWindow.dismiss();
    }

    public void resetParentView(View view) {
        this.parentView = view;
    }

    private void makePopupWindow() {
        View contentView = LayoutInflater.from((Context)this.context).inflate(R.layout.moments_my_moments_pop, null);
        this.windowPos = this.calculatePopWindowPos(this.parentView, contentView);
        TextView myMoments = (TextView)contentView.findViewById(R.id.tv_my_moment);
        TextView atMine = (TextView)contentView.findViewById(R.id.tv_at_mine);
        TextView myComments = (TextView)contentView.findViewById(R.id.tv_my_comments);
        TextView receivePraise = (TextView)contentView.findViewById(R.id.tv_receive_praise);
        myMoments.setOnClickListener(view -> this.listener.onMyMomentsClick());
        atMine.setOnClickListener(view -> this.listener.onAtMineClick());
        myComments.setOnClickListener(view -> this.listener.onMyCommentsClick());
        receivePraise.setOnClickListener(view -> this.listener.onReceivePraiseClick());
        this.mPopupWindow = new PopupWindow((Context)this.context);
        this.mPopupWindow.setOnDismissListener(() -> {
            if (this.onDisMissListener != null) {
                this.onDisMissListener.onPopDisMiss();
            }
        });
        this.mPopupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        contentView.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        this.mPopupWindow.setContentView(contentView);
        this.mPopupWindow.setWidth(-2);
        this.mPopupWindow.setHeight(-2);
        this.mPopupWindow.setFocusable(true);
        this.mPopupWindow.setTouchable(true);
        this.mPopupWindow.setOutsideTouchable(true);
    }

    public void setOnItemClickLsitener(OnItemClickListener listener) {
        this.listener = listener;
    }

    public void setOnDisMissListener(OnDisMissListener listener) {
        this.onDisMissListener = listener;
    }

    private int[] calculatePopWindowPos(View anchorView, View contentView) {
        int[] windowPos = new int[2];
        int[] anchorLoc = new int[2];
        anchorView.getLocationOnScreen(anchorLoc);
        anchorView.measure(0, 0);
        int anchorViewWidth = anchorView.getMeasuredWidth();
        contentView.measure(0, 0);
        int contentwWidth = contentView.getMeasuredWidth();
        windowPos[0] = anchorViewWidth / 2 - contentwWidth / 2;
        windowPos[1] = anchorLoc[1];
        return windowPos;
    }

    public static interface OnDisMissListener {
        public void onPopDisMiss();
    }

    public static interface OnItemClickListener {
        public void onMyMomentsClick();

        public void onAtMineClick();

        public void onMyCommentsClick();

        public void onReceivePraiseClick();
    }
}

