/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.account.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xdja.cssp.account.service.api.AccountService;
import com.xdja.cssp.account.service.api.bean.Account;
import com.xdja.cssp.account.service.api.bean.AccountInfo;
import com.xdja.cssp.account.service.api.bean.UpdateResult;
import com.xdja.cssp.account.service.api.exception.RescourceNotFoundException;
import com.xdja.cssp.account.service.jedis.AccountScoreJedisAction;
import com.xdja.cssp.account.service.jedis.EcContactJedisAction;
import com.xdja.cssp.account.service.jedis.FriendJedisAction;
import com.xdja.cssp.account.service.jedis.GroupMemberJedisAction;
import com.xdja.cssp.account.service.jedis.TimesJedisAction;
import com.xdja.cssp.ums.model.Result;
import com.xdja.cssp.ums.service.IAccountService;
import com.xdja.platform.common.lite.kit.json.JSONException;
import com.xdja.platform.common.lite.kit.json.JsonMapper;
import com.xdja.platform.common.lite.kit.prop.Prop;
import com.xdja.platform.common.lite.kit.prop.PropKit;
import com.xdja.platform.redis.core.RedisClient;
import com.xdja.platform.redis.core.action.JedisAction;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Tuple;

@Component
public class AccountServiceImpl
implements AccountService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private RedisClient baseRC;
    @Resource
    private RedisClient atRC;
    private static int QUERY_BATCH_SIZE = 10000;
    IAccountService accountService = (IAccountService)DefaultServiceRefer.getServiceRefer(IAccountService.class);

    public UpdateResult queryAccounts(String account, Long lastUpdateId, Integer batchSize) {
        if (null == batchSize || batchSize == 0) {
            batchSize = 10;
        }
        if (null == lastUpdateId) {
            lastUpdateId = -1L;
        }
        HashSet<String> relationalAccounts = new HashSet<String>();
        relationalAccounts.addAll(this.getFriendAccounts(account));
        relationalAccounts.addAll(this.getGroupAccounts(account));
        relationalAccounts.addAll(this.getEcContactAccounts(account));
        UpdateResult result = new UpdateResult();
        result.setLastUpdateId(lastUpdateId);
        result.setAccounts(new ArrayList());
        Long times = (Long)this.baseRC.execute((JedisAction)new TimesJedisAction(lastUpdateId, QUERY_BATCH_SIZE));
        int i = 0;
        while ((long)i < times) {
            Set tupleSet = (Set)this.baseRC.execute((JedisAction)new AccountScoreJedisAction(lastUpdateId, QUERY_BATCH_SIZE));
            for (Tuple t : tupleSet) {
                lastUpdateId = Double.valueOf(t.getScore()).longValue();
                if (!relationalAccounts.contains(t.getElement().replaceFirst("acc_", ""))) continue;
                result.setLastUpdateId(lastUpdateId);
                try {
                    result.addAccount((Account)JsonMapper.alwaysMapper().fromJson(this.baseRC.hget(t.getElement(), "v"), (TypeReference)new TypeReference<Account>(){}));
                }
                catch (JSONException e) {
                    this.logger.error("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6\u8d26\u6237\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                }
                if (result.getAccountSize() != batchSize.intValue()) continue;
                break;
            }
            if (result.getAccountSize() == batchSize.intValue()) break;
            ++i;
        }
        return result;
    }

    private Set<String> getFriendAccounts(String account) {
        return (Set)this.atRC.execute((JedisAction)new FriendJedisAction(account));
    }

    private Set<String> getGroupAccounts(String account) {
        return (Set)this.atRC.execute((JedisAction)new GroupMemberJedisAction(account));
    }

    private Set<String> getEcContactAccounts(String account) {
        return (Set)this.atRC.execute((JedisAction)new EcContactJedisAction(account));
    }

    public String getEcCodeByAccount(String account) {
        return this.atRC.get("ecContact:" + account);
    }

    public AccountInfo getAccountByCardNo(String cardNo) {
        if (StringUtils.isBlank((CharSequence)cardNo)) {
            this.logger.error("\u83b7\u53d6\u8d26\u6237\u65f6\uff0c\u8f93\u5165\u53c2\u6570\u9519\u8bef");
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef");
        }
        Result result = this.accountService.getUserInfo(cardNo);
        switch (result.getResultStatus()) {
            case 1: {
                Map accountMap = (Map)result.getInfo();
                AccountInfo account = new AccountInfo();
                account.setAccount((String)accountMap.get("account"));
                account.setDeviceName((String)accountMap.get("deviceName"));
                account.setNickname((String)accountMap.get("nickName"));
                account.setNicknamePy((String)accountMap.get("simpleSpell"));
                account.setNicknamePinyin((String)accountMap.get("spell"));
                account.setMail((String)accountMap.get("mail"));
                account.setMobile((String)accountMap.get("mobile"));
                account.setAvatar((String)accountMap.get("avatarFileName"));
                account.setThumbnail((String)accountMap.get("thumbnailName"));
                account.setAvatarDownloadUrl(AccountServiceImpl.getDownloadUrl((String)accountMap.get("avatarFilePath")));
                account.setThumbnailDownloadUrl(AccountServiceImpl.getDownloadUrl((String)accountMap.get("thumbnailPath")));
                account.setCompanyCode(this.atRC.get("ecContact:" + (String)accountMap.get("account")));
                return account;
            }
            case 2: {
                this.logger.error("\u8bbe\u5907\u672a\u6ce8\u518c,\u8bbe\u5907\u5361\u53f7\u4e3a\uff1a" + cardNo);
                throw new RescourceNotFoundException("\u8bbe\u5907\u672a\u6ce8\u518c");
            }
        }
        return null;
    }

    private static String getDownloadUrl(String fileId) {
        if (StringUtils.isNotBlank((CharSequence)fileId)) {
            Prop prop = PropKit.use((String)"system.properties");
            return prop.get("fileagent.downloadUrl") + "/" + fileId;
        }
        return null;
    }
}

