/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.account.service.jedis;

import com.xdja.cssp.account.service.Constants;
import com.xdja.platform.redis.core.action.JedisAction;
import redis.clients.jedis.Jedis;

public class TimesJedisAction
implements JedisAction<Long> {
    private Long lastUpdateId = -1L;
    private int queryBatchSize = 10000;

    public TimesJedisAction(Long lastUpdateId, int queryBatchSize) {
        this.lastUpdateId = lastUpdateId;
        this.queryBatchSize = queryBatchSize;
    }

    public Long action(Jedis jedis) {
        Long count = jedis.zcount(Constants.REDIS_KEY_ACCOUNT_SCORE, "" + this.lastUpdateId, "+inf");
        long times = count / (long)this.queryBatchSize;
        if (count % (long)this.queryBatchSize > 0L) {
            ++times;
        }
        return times;
    }
}

