/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.ec.contact.api;

import com.xdja.cssp.as.ticket.AsBean;
import com.xdja.cssp.as.ticket.annotation.CheckTicket;
import com.xdja.cssp.ec.contact.api.Constants;
import com.xdja.cssp.ec.contact.api.exception.NotBelongEcException;
import com.xdja.cssp.ec.contact.service.api.ContactService;
import com.xdja.cssp.ec.contact.service.api.bean.Person;
import com.xdja.cssp.ec.contact.service.api.bean.UpdateContactPersonsResult;
import com.xdja.cssp.key.server.api.IKsfService;
import com.xdja.cssp.key.server.api.bean.ResultKsfBean;
import com.xdja.cssp.restful.exception.BadRequestException;
import com.xdja.cssp.restful.exception.InternalServerException;
import com.xdja.platform.common.lite.kit.StrKit;
import com.xdja.platform.rpc.consumer.refer.DefaultServiceRefer;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ContactAPI {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ContactService contactService = (ContactService)DefaultServiceRefer.getServiceRefer(ContactService.class);
    private IKsfService ksfService = (IKsfService)DefaultServiceRefer.getServiceRefer(IKsfService.class);

    @RequestMapping(value={"/contact/detector"}, method={RequestMethod.GET})
    @CheckTicket
    public Object detectContact(Long deptLastUpdateId, Long personLastUpdateId, AsBean asBean) {
        if (null == asBean) {
            this.logger.error("\u4e0d\u53ef\u6062\u590d\u5f02\u5e38\uff1a\u57fa\u4e8eaop\u7684VerifyTicketAspect\u5207\u9762\u5931\u6548\uff0c\u8bf7\u68c0\u67e5aop\u76f8\u5173\u914d\u7f6e\uff0c\u5e76\u5728\u8be5\u65b9\u6cd5\u524d\u6dfb\u52a0\u6ce8\u89e3@CheckTicket");
            throw new InternalServerException("unknown", "unknown", "internal_server_error", "\u670d\u52a1\u5f02\u5e38,\u8bf7\u6c42\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        String requestId = asBean.getRequestId();
        String ecCode = this.contactService.getEcCodeByAccount(asBean.getAccount());
        if (StrKit.isBlank((String)ecCode)) {
            this.logger.info("\u8d26\u53f7{}\u4e0d\u5c5e\u4e8e\u4efb\u4f55\u96c6\u56e2", (Object)asBean.getAccount());
            throw new NotBelongEcException(this.getHostId(), requestId, "\u8be5\u8d26\u53f7\u4e0d\u5c5e\u4e8e\u4efb\u4f55\u96c6\u56e2");
        }
        try {
            return this.contactService.updateDetect(ecCode, deptLastUpdateId, personLastUpdateId);
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u96c6\u56e2\u901a\u8baf\u5f55RPC\u670d\u52a1\u68c0\u6d4b\u901a\u8baf\u5f55\u66f4\u65b0\u5f02\u5e38", (Throwable)e);
            throw new InternalServerException(this.getHostId(), requestId, "internal_server_error", e.getMessage(), (Throwable)e);
        }
    }

    @RequestMapping(value={"/contact/depts"}, method={RequestMethod.GET})
    @CheckTicket
    public Object updateDepts(Long deptLastUpdateId, Long deptSubUpdateId, Integer batchSize, AsBean asBean) {
        String ecCode;
        if (null == asBean) {
            this.logger.error("\u4e0d\u53ef\u6062\u590d\u5f02\u5e38\uff1a\u57fa\u4e8eaop\u7684VerifyTicketAspect\u5207\u9762\u5931\u6548\uff0c\u8bf7\u68c0\u67e5aop\u76f8\u5173\u914d\u7f6e\uff0c\u5e76\u5728\u8be5\u65b9\u6cd5\u524d\u6dfb\u52a0\u6ce8\u89e3@CheckTicket");
            throw new InternalServerException("unknown", "unknown", "internal_server_error", "\u670d\u52a1\u5f02\u5e38,\u8bf7\u6c42\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        String requestId = asBean.getRequestId();
        if (null == deptSubUpdateId) {
            throw new BadRequestException(this.getHostId(), requestId, "request_params_not_valid", "\u8bf7\u6c42\u53c2\u6570deptSubUpdateId(\u90e8\u95e8\u66f4\u65b0\u622a\u6b62\u6807\u8bc6)\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (null == batchSize) {
            batchSize = 10;
        }
        if (null == deptLastUpdateId) {
            deptLastUpdateId = 0L;
        }
        if (StrKit.isBlank((String)(ecCode = this.contactService.getEcCodeByAccount(asBean.getAccount())))) {
            this.logger.info("\u8d26\u53f7{}\u4e0d\u5c5e\u4e8e\u4efb\u4f55\u96c6\u56e2", (Object)asBean.getAccount());
            throw new NotBelongEcException(this.getHostId(), requestId, "\u8be5\u8d26\u53f7\u4e0d\u5c5e\u4e8e\u4efb\u4f55\u96c6\u56e2");
        }
        try {
            return this.contactService.queryDepts(ecCode, deptLastUpdateId, deptSubUpdateId, batchSize);
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u96c6\u56e2\u901a\u8baf\u5f55RPC\u670d\u52a1\u6279\u91cf\u66f4\u65b0\u90e8\u95e8\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            throw new InternalServerException(this.getHostId(), requestId, "internal_server_error", e.getMessage(), (Throwable)e);
        }
    }

    @RequestMapping(value={"/contact/persons"}, method={RequestMethod.GET})
    @CheckTicket
    public Object updatePersons(Long personLastUpdateId, Long personSubUpdateId, Integer batchSize, AsBean asBean) {
        String ecCode;
        if (null == asBean) {
            this.logger.error("\u4e0d\u53ef\u6062\u590d\u5f02\u5e38\uff1a\u57fa\u4e8eaop\u7684VerifyTicketAspect\u5207\u9762\u5931\u6548\uff0c\u8bf7\u68c0\u67e5aop\u76f8\u5173\u914d\u7f6e\uff0c\u5e76\u5728\u8be5\u65b9\u6cd5\u524d\u6dfb\u52a0\u6ce8\u89e3@CheckTicket");
            throw new InternalServerException("unknown", "unknown", "internal_server_error", "\u670d\u52a1\u5f02\u5e38,\u8bf7\u6c42\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        String requestId = asBean.getRequestId();
        if (null == personSubUpdateId) {
            throw new BadRequestException(this.getHostId(), requestId, "request_params_not_valid", "\u8bf7\u6c42\u53c2\u6570personSubUpdateId(\u4eba\u5458\u66f4\u65b0\u622a\u6b62\u6807\u8bc6)\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (null == batchSize) {
            batchSize = 10;
        }
        if (null == personLastUpdateId) {
            personLastUpdateId = 0L;
        }
        if (StrKit.isBlank((String)(ecCode = this.contactService.getEcCodeByAccount(asBean.getAccount())))) {
            this.logger.info("\u8d26\u53f7{}\u4e0d\u5c5e\u4e8e\u4efb\u4f55\u96c6\u56e2", (Object)asBean.getAccount());
            throw new NotBelongEcException(this.getHostId(), requestId, "\u8be5\u8d26\u53f7\u4e0d\u5c5e\u4e8e\u4efb\u4f55\u96c6\u56e2");
        }
        try {
            UpdateContactPersonsResult result = this.contactService.queryPersons(ecCode, personLastUpdateId, personSubUpdateId, batchSize);
            ArrayList<String> fAccounts = new ArrayList<String>();
            for (Person person : result.getPersons()) {
                if (!StrKit.notBlank((String)person.getAccount())) continue;
                fAccounts.add(person.getAccount());
            }
            if (!fAccounts.isEmpty()) {
                Map accountKsfs = this.ksfService.queryAccountKsfs(asBean.getAccount(), fAccounts);
                String account = null;
                ResultKsfBean ksf = null;
                for (Person person : result.getPersons()) {
                    account = person.getAccount();
                    if (StrKit.isBlank((String)account) || !accountKsfs.containsKey(account)) continue;
                    ksf = (ResultKsfBean)accountKsfs.get(account);
                    person.setKsf(ksf.getEncryptKsf());
                    person.setKsfId(ksf.getKsfId());
                    person.setKsfKuepId(ksf.getKuepId());
                }
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u96c6\u56e2\u901a\u8baf\u5f55RPC\u670d\u52a1\u6279\u91cf\u66f4\u65b0\u4eba\u5458\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            throw new InternalServerException(this.getHostId(), requestId, "internal_server_error", e.getMessage(), (Throwable)e);
        }
    }

    public String getHostId() {
        return Constants.HOST_ID;
    }
}

