/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pmc.service.business.implement;

import com.xdja.platform.microservice.db.nutz.Dao;
import com.xdja.pmc.service.business.interfaces.TerminalManagerBusiness;
import com.xdja.pmc.service.instruction.entity.TerminalInstruction;
import com.xdja.pmc.service.terminalmanager.bean.TerminalInstructionLocation;
import com.xdja.pmc.service.terminalmanager.bean.TerminalInstructionPhoto;
import java.util.List;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Sqls;
import org.nutz.dao.sql.Sql;
import org.nutz.trans.Atom;
import org.nutz.trans.Trans;
import org.springframework.stereotype.Service;

@Service
public class TerminalManagerBusinessImpl
implements TerminalManagerBusiness {
    private Dao dao = Dao.use((String)"db::pmc");

    @Override
    public boolean isExistInstruction(String imei, String instructionId) {
        List list = this.dao.query(TerminalInstruction.class, (Condition)Cnd.where((String)"imei", (String)"=", (Object)imei).and("instructionId", "=", (Object)instructionId).and("resultStatus", "=", (Object)1));
        return list != null && list.size() > 0;
    }

    @Override
    public TerminalInstruction getResultStatus(String groupId) {
        return (TerminalInstruction)this.dao.fetch(TerminalInstruction.class, (Condition)Cnd.where((String)"instructionSeq", (String)"=", (Object)groupId));
    }

    @Override
    public void saveTerminalLocation(TerminalInstructionLocation location) {
        this.dao.insert((Object)location);
    }

    @Override
    public TerminalInstructionLocation getLastLocationHistory(String deviceId) {
        Cnd cnd = Cnd.where((String)"imei", (String)"=", (Object)deviceId);
        cnd.getOrderBy().desc("time");
        return (TerminalInstructionLocation)this.dao.fetch(TerminalInstructionLocation.class, (Condition)cnd);
    }

    @Override
    public TerminalInstructionLocation getLocationResult(String instructionSeq) {
        return (TerminalInstructionLocation)this.dao.fetch(TerminalInstructionLocation.class, (Condition)Cnd.where((String)"instructionSeq", (String)"=", (Object)instructionSeq));
    }

    @Override
    public TerminalInstruction getResultStatusBySeq(String instructionSeq) {
        return (TerminalInstruction)this.dao.fetch(TerminalInstruction.class, (Condition)Cnd.where((String)"instructionSeq", (String)"=", (Object)instructionSeq));
    }

    @Override
    public void updateOldInstruction(List<String> imeis, String instructionType, int resultStatus) {
        Sql[] sqlArr = new Sql[2];
        StringBuffer sqlBuffer1 = new StringBuffer(" DELETE FROM t_pmc_terminal_instruction_handling ");
        sqlBuffer1.append(" $condition");
        Sql sql1 = Sqls.create((String)sqlBuffer1.toString());
        sql1.setCondition((Condition)Cnd.where((String)"c_imei", (String)"in", imeis).and("c_instruction_id", "=", (Object)instructionType));
        sqlArr[0] = sql1;
        StringBuffer sqlBuffer2 = new StringBuffer("UPDATE t_pmc_terminal_instruction SET n_result_status = @resultStatus");
        sqlBuffer2.append(" $condition");
        Sql sql2 = Sqls.create((String)sqlBuffer2.toString());
        sql2.setCondition((Condition)Cnd.where((String)"c_imei", (String)"in", imeis).and("c_instruction_id", "=", (Object)instructionType).and("n_result_status", "=", (Object)1));
        sql2.params().set("resultStatus", (Object)resultStatus);
        sqlArr[1] = sql2;
        this.dao.execute(sqlArr);
    }

    @Override
    public void saveTerminalPhoto(TerminalInstructionPhoto instructionPhoto) {
        this.dao.insert((Object)instructionPhoto);
    }

    @Override
    public List<TerminalInstructionPhoto> getLastPhotoHistorys(String deviceId) {
        Cnd cnd = Cnd.where((String)"imei", (String)"=", (Object)deviceId);
        cnd.getOrderBy().desc("time");
        cnd.limit(1, 3);
        return this.dao.query(TerminalInstructionPhoto.class, (Condition)cnd);
    }

    @Override
    public TerminalInstructionPhoto getPhotoResult(String seq) {
        return (TerminalInstructionPhoto)this.dao.fetch(TerminalInstructionPhoto.class, (Condition)Cnd.where((String)"instructionSeq", (String)"=", (Object)seq));
    }

    @Override
    public List<TerminalInstructionPhoto> queryPhotos(String imei) {
        Cnd cnd = Cnd.where((String)"imei", (String)"=", (Object)imei);
        cnd.getOrderBy().desc("time");
        cnd.limit(1, 20);
        return this.dao.query(TerminalInstructionPhoto.class, (Condition)cnd);
    }

    @Override
    public List<TerminalInstructionPhoto> getPhotoResultList(String seq, String imei) {
        Cnd cnd = Cnd.where((String)"imei", (String)"=", (Object)imei).and("instructionSeq", "<>", (Object)seq);
        cnd.getOrderBy().desc("time");
        cnd.limit(1, 2);
        return this.dao.query(TerminalInstructionPhoto.class, (Condition)cnd);
    }

    @Override
    public List<TerminalInstruction> queryTerminalInstructionWithNotReported(String imei, String instructionId) {
        return this.dao.query(TerminalInstruction.class, (Condition)Cnd.where((String)"imei", (String)"=", (Object)imei).and("instructionId", "=", (Object)instructionId).and("resultStatus", "=", (Object)1));
    }

    @Override
    public void deletePhotos(final String[] picNames) {
        Trans.exec((Atom[])new Atom[]{new Atom(){

            public void run() {
                Sql[] sqlArr = new Sql[1];
                StringBuffer sqlBuffer = new StringBuffer(" DELETE FROM t_pmc_terminal_instruction_photo");
                sqlBuffer.append(" $condition");
                Sql sql = Sqls.create((String)sqlBuffer.toString());
                sql.setCondition((Condition)Cnd.where((String)"c_pic_url", (String)"in", (Object)picNames));
                sqlArr[0] = sql;
                TerminalManagerBusinessImpl.this.dao.execute(sqlArr);
            }
        }});
    }

    @Override
    public TerminalInstruction getLastResult(String imei, String type) {
        Cnd cnd = Cnd.where((String)"imei", (String)"=", (Object)imei).and("instructionId", "=", (Object)type);
        cnd.getOrderBy().desc("resultTime");
        return (TerminalInstruction)this.dao.fetch(TerminalInstruction.class, (Condition)cnd);
    }
}

