/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pmc.service.implement;

import com.xdja.platform.log.Logger;
import com.xdja.platform.log.LoggerFactory;
import com.xdja.platform.util.DateTimeUtil;
import com.xdja.platform.util.json.JSONException;
import com.xdja.platform.util.json.JSONUtil;
import com.xdja.pmc.service.business.interfaces.TerminalManagerBusiness;
import com.xdja.pmc.service.core.UUID;
import com.xdja.pmc.service.instruction.bean.InstructionBean;
import com.xdja.pmc.service.instruction.entity.TerminalInstruction;
import com.xdja.pmc.service.instruction.exception.LackofArgsException;
import com.xdja.pmc.service.instruction.exception.OutOfRangeException;
import com.xdja.pmc.service.instruction.sender.InstructionClient;
import com.xdja.pmc.service.terminalmanager.bean.InstructionResultLocation;
import com.xdja.pmc.service.terminalmanager.bean.InstructionResultPhoto;
import com.xdja.pmc.service.terminalmanager.bean.LocationData;
import com.xdja.pmc.service.terminalmanager.bean.PhotoBean;
import com.xdja.pmc.service.terminalmanager.bean.Photos;
import com.xdja.pmc.service.terminalmanager.bean.ResultPhotoData;
import com.xdja.pmc.service.terminalmanager.bean.ResultStatus;
import com.xdja.pmc.service.terminalmanager.bean.TerminalInstructionLocation;
import com.xdja.pmc.service.terminalmanager.bean.TerminalInstructionPhoto;
import com.xdja.pmc.service.terminalmanager.interfaces.TerminalManagerService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TerminalManagerServiceImpl
implements TerminalManagerService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    TerminalManagerBusiness terminalManagerBusiness;

    private ResultStatus validateInstruction(String online, String instructionType, ResultStatus status) {
        boolean temp = this.terminalManagerBusiness.isExistInstruction(status.getImei(), instructionType);
        if (temp && online.equals("0")) {
            status.setStatus(-1);
        }
        return status;
    }

    private ResultStatus sendInstruction(String instructionType, String content, ResultStatus status) {
        ArrayList<String> imeis = new ArrayList<String>();
        imeis.add(status.getImei());
        this.updateOldInstruction(imeis, instructionType, 2);
        ArrayList<InstructionBean> instructionBeans = new ArrayList<InstructionBean>();
        InstructionBean instructionBean = new InstructionBean();
        instructionBean.setImei(status.getImei());
        instructionBean.setId(instructionType);
        instructionBean.setSeq(status.getInstructionSeq());
        instructionBean.setGroupId(status.getGroupId());
        instructionBean.setContent(content);
        instructionBean.setServiceCode("002");
        instructionBean.setType(Integer.valueOf(1));
        instructionBeans.add(instructionBean);
        status.setStatus(1);
        try {
            InstructionClient.sendAsyn(instructionBeans);
        }
        catch (LackofArgsException e) {
            this.logger.error("\u7f3a\u5931\u6307\u4ee4\u53d1\u9001\u53c2\u6570", (Throwable)e);
        }
        catch (OutOfRangeException e) {
            this.logger.error("\u53d1\u751f\u6307\u4ee4\u5185\u5bb9\u8fc7\u957f", (Throwable)e);
        }
        return status;
    }

    public ResultStatus deviceFrozen(String imei, String alarmInfo, String frozenPwd, String online) {
        ResultStatus frozenResultStatus = new ResultStatus();
        frozenResultStatus.setGroupId(UUID.getUUID());
        frozenResultStatus.setInstructionSeq(UUID.getUUID());
        frozenResultStatus.setImei(imei);
        frozenResultStatus = this.validateInstruction(online, "CMD_REMOTE_LOCK", frozenResultStatus);
        HashMap<String, String> contentMap = new HashMap<String, String>();
        contentMap.put("alarmInfo", alarmInfo == null ? "" : alarmInfo);
        contentMap.put("cardCommand", frozenPwd);
        String content = null;
        try {
            content = JSONUtil.toJSONString(contentMap);
        }
        catch (JSONException e1) {
            this.logger.error("\u6307\u4ee4\u5185\u5bb9JSON\u683c\u5f0f\u9519\u8bef");
        }
        if (frozenResultStatus.getStatus() == -1) {
            this.logger.debug("\u79bb\u7ebf\u6307\u4ee4\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u518d\u6b21\u53d1\u9001");
        } else {
            this.sendInstruction("CMD_REMOTE_LOCK", content, frozenResultStatus);
        }
        return frozenResultStatus;
    }

    public ResultStatus delDevice(String imei, String online) {
        ResultStatus resultStatus = new ResultStatus();
        resultStatus.setGroupId(UUID.getUUID());
        resultStatus.setInstructionSeq(UUID.getUUID());
        resultStatus.setImei(imei);
        resultStatus = this.validateInstruction(online, "CMD_DEL_DEVICE", resultStatus);
        if (resultStatus.getStatus() == -1) {
            return resultStatus;
        }
        return this.sendInstruction("CMD_DEL_DEVICE", String.valueOf(2), resultStatus);
    }

    public ResultStatus getResultStatus(String groupId) {
        TerminalInstruction instruction = this.terminalManagerBusiness.getResultStatus(groupId);
        ResultStatus resultStatus = new ResultStatus();
        resultStatus.setGroupId(groupId);
        resultStatus.setImei(instruction.getImei());
        resultStatus.setStatus(instruction.getResultStatus().intValue());
        return resultStatus;
    }

    public ResultStatus alarmDevice(String imei, String online) {
        ResultStatus resultStatus = new ResultStatus();
        resultStatus.setGroupId(UUID.getUUID());
        resultStatus.setInstructionSeq(UUID.getUUID());
        resultStatus.setImei(imei);
        resultStatus = this.validateInstruction(online, "CMD_ALARM", resultStatus);
        return this.sendInstruction("CMD_ALARM", null, resultStatus);
    }

    public void saveTerminalLocation(TerminalInstructionLocation location) {
        this.terminalManagerBusiness.saveTerminalLocation(location);
    }

    public InstructionResultLocation getLastLocationHistory(String deviceId) {
        TerminalInstructionLocation result = this.terminalManagerBusiness.getLastLocationHistory(deviceId);
        InstructionResultLocation locationResult = new InstructionResultLocation();
        if (result == null) {
            locationResult.setStatus(Integer.valueOf(0));
        } else {
            locationResult.setStatus(Integer.valueOf(1));
            LocationData data = new LocationData();
            data.setLat(result.getLatitude().doubleValue());
            data.setLon(result.getLongitude().doubleValue());
            data.setAddress(result.getLocation());
            data.setTime(result.getTime().longValue());
            locationResult.setData(data);
        }
        return locationResult;
    }

    public ResultStatus locateDevice(String deviceId, String online) {
        ResultStatus resultStatus = new ResultStatus();
        resultStatus.setGroupId(UUID.getUUID());
        resultStatus.setInstructionSeq(UUID.getUUID());
        resultStatus.setImei(deviceId);
        resultStatus = this.validateInstruction(online, "CMD_LOCATE_REAL_TIME", resultStatus);
        return this.sendInstruction("CMD_LOCATE_REAL_TIME", null, resultStatus);
    }

    public InstructionResultLocation getLocationResult(String instructionSeq) {
        TerminalInstructionLocation locationResult;
        InstructionResultLocation location = new InstructionResultLocation();
        TerminalInstruction instruction = this.terminalManagerBusiness.getResultStatusBySeq(instructionSeq);
        location.setInstructionSeq(instruction.getInstructionSeq());
        location.setStatus(instruction.getResultStatus());
        location.setImei(instruction.getImei());
        if (instruction.getResultStatus().equals(3) && (locationResult = this.terminalManagerBusiness.getLocationResult(instructionSeq)) != null) {
            LocationData data = new LocationData();
            data.setLat(locationResult.getLatitude().doubleValue());
            data.setLon(locationResult.getLongitude().doubleValue());
            data.setTime(locationResult.getTime().longValue());
            data.setAddress(locationResult.getLocation());
            location.setData(data);
        }
        return location;
    }

    public void modifyDeviceName(String deviceId, String deviceName) {
        ResultStatus status = new ResultStatus();
        status.setGroupId(UUID.getUUID());
        status.setInstructionSeq(UUID.getUUID());
        status.setImei(deviceId);
        this.sendInstruction("CMD_MODIFY_DEVICE_NAME", deviceName, status);
    }

    private void updateOldInstruction(List<String> imeis, String instructionType, int resultStatus) {
        this.terminalManagerBusiness.updateOldInstruction(imeis, instructionType, resultStatus);
    }

    private void sendInstructions(List<String> imeis, String instructionType, String groupId, String content) {
        if (imeis != null && imeis.size() > 0) {
            this.updateOldInstruction(imeis, instructionType, 2);
            ArrayList<InstructionBean> instructionBeans = new ArrayList<InstructionBean>();
            for (String imei : imeis) {
                InstructionBean instructionBean = new InstructionBean();
                instructionBean.setImei(imei);
                instructionBean.setId(instructionType);
                instructionBean.setSeq(UUID.getUUID());
                instructionBean.setGroupId(groupId);
                instructionBean.setContent(content);
                instructionBean.setServiceCode("002");
                instructionBean.setType(Integer.valueOf(1));
                instructionBeans.add(instructionBean);
            }
            try {
                InstructionClient.sendAsyn(instructionBeans);
            }
            catch (LackofArgsException e) {
                this.logger.error("\u7f3a\u5931\u6307\u4ee4\u53d1\u9001\u53c2\u6570", (Throwable)e);
            }
            catch (OutOfRangeException e) {
                this.logger.error("\u53d1\u751f\u6307\u4ee4\u5185\u5bb9\u8fc7\u957f", (Throwable)e);
            }
        } else {
            this.logger.debug("\u83b7\u53d6\u8bbe\u5907\u6807\u8bc6\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d1\u9001\u6307\u4ee4");
        }
    }

    public void sendModifyAccountNicknameInstructions(List<String> imeis, String nickName) {
        StringBuilder content = new StringBuilder();
        content.append(String.format("%-14s", nickName)).append(System.currentTimeMillis());
        this.sendInstructions(imeis, "CMD_MODIFY_ACCOUNT_NICKNAME", UUID.getUUID(), content.toString());
    }

    public void sendModifyAccountHeadImageInstructions(List<String> imeis, String headImage) {
        this.sendInstructions(imeis, "CMD_MODIFY_ACCOUNT_HEADIMAGE", UUID.getUUID(), headImage);
    }

    public void sendDeviceRegInstruction(String deviceId, String account) {
        ResultStatus status = new ResultStatus();
        status.setGroupId(UUID.getUUID());
        status.setInstructionSeq(UUID.getUUID());
        status.setImei(deviceId);
        this.sendInstruction("CMD_DEVICE_REGISTER", account, status);
    }

    public void sendModifyAccountPhoneInstructions(List<String> imeis, String phone) {
        this.sendInstructions(imeis, "CMD_MODIFY_ACCOUNT_PHONE", UUID.getUUID(), phone);
    }

    public ResultStatus photoDevice(String deviceId) {
        ResultStatus resultStatus = new ResultStatus();
        resultStatus.setGroupId(UUID.getUUID());
        resultStatus.setInstructionSeq(UUID.getUUID());
        resultStatus.setImei(deviceId);
        return this.sendInstruction("CMD_PHOTOGRAPH", null, resultStatus);
    }

    public void saveTerminalPhoto(TerminalInstructionPhoto instructionPhoto) {
        this.terminalManagerBusiness.saveTerminalPhoto(instructionPhoto);
    }

    public List<TerminalInstructionPhoto> getLastPhotoHistorys(String deviceId) {
        return this.terminalManagerBusiness.getLastPhotoHistorys(deviceId);
    }

    public InstructionResultPhoto getPhotoResultStatus(String seq) {
        InstructionResultPhoto resultPhoto = new InstructionResultPhoto();
        TerminalInstruction instruction = this.terminalManagerBusiness.getResultStatusBySeq(seq);
        if (instruction != null) {
            resultPhoto.setInstructionSeq(instruction.getInstructionSeq());
            resultPhoto.setStatus(instruction.getResultStatus());
            if (resultPhoto.getStatus().equals(3)) {
                ArrayList<ResultPhotoData> data = new ArrayList<ResultPhotoData>();
                ResultPhotoData photoData = new ResultPhotoData();
                TerminalInstructionPhoto photo = this.terminalManagerBusiness.getPhotoResult(seq);
                if (photo != null) {
                    photoData.setUrl(photo.getPicUrl());
                    photoData.setTime("\u5f53\u524d\u62cd\u7167\u65f6\u95f4\uff08" + DateTimeUtil.longToDateStr((long)photo.getTime()) + "\uff09");
                    data.add(photoData);
                }
                resultPhoto.setData(data);
            }
        }
        return resultPhoto;
    }

    public List<Photos> queryPhotosByImei(String imei) {
        List<TerminalInstructionPhoto> list = this.terminalManagerBusiness.queryPhotos(imei);
        if (list != null && list.size() > 0) {
            LinkedList<Photos> photos = new LinkedList<Photos>();
            for (int i = 0; i < list.size(); ++i) {
                TerminalInstructionPhoto terminalInstructionPhoto = list.get(i);
                Photos photoData = new Photos();
                photoData.setDate(DateTimeUtil.dateToStr((Date)new Date(terminalInstructionPhoto.getTime()), (String)"yyyy\u5e74MM\u6708dd\u65e5"));
                PhotoBean photoBean = new PhotoBean();
                photoBean.setName(terminalInstructionPhoto.getPicUrl());
                photoBean.setTime(terminalInstructionPhoto.getTime());
                photoBean.setTimeStr(DateTimeUtil.dateToStr((Date)new Date(terminalInstructionPhoto.getTime()), (String)"HH:mm"));
                if (photos.contains(photoData)) {
                    int index = photos.indexOf(photoData);
                    List datas = ((Photos)photos.get(index)).getDatas();
                    datas.add(photoBean);
                    ((Photos)photos.get(index)).setCount(datas.size());
                    continue;
                }
                LinkedList<PhotoBean> datas = new LinkedList<PhotoBean>();
                datas.add(photoBean);
                photoData.setDatas(datas);
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(terminalInstructionPhoto.getTime());
                photoData.setWeek(calendar.get(7));
                photoData.setCount(1);
                photos.add(photoData);
            }
            return photos;
        }
        return null;
    }

    public void doDelete(String[] picNames) {
        this.terminalManagerBusiness.deletePhotos(picNames);
    }

    public Map<String, Integer> getLastResult(String imei) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        TerminalInstruction frozenResult = this.terminalManagerBusiness.getLastResult(imei, "CMD_REMOTE_LOCK");
        TerminalInstruction delResult = this.terminalManagerBusiness.getLastResult(imei, "CMD_DEL_DEVICE");
        TerminalInstruction alarmResult = this.terminalManagerBusiness.getLastResult(imei, "CMD_ALARM");
        if (frozenResult != null) {
            map.put("CMD_REMOTE_LOCK", frozenResult.getResultStatus());
        }
        if (delResult != null) {
            map.put("CMD_DEL_DEVICE", delResult.getResultStatus());
        }
        if (alarmResult != null) {
            map.put("CMD_ALARM", alarmResult.getResultStatus());
        }
        return map;
    }
}

