/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.app.data;

import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfSymmetricKeyParameters;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSymmetricEncryptUtils;
import com.xdja.pki.gmssl.sdf.bean.SdfAlgIdSymmetric;
import com.xdja.pki.itsca.oer.app.bean.PKRecipientInfoType;
import com.xdja.pki.itsca.oer.app.data.KekBuilder;
import com.xdja.pki.itsca.oer.asn1.Certificate;
import com.xdja.pki.itsca.oer.asn1.CipherText;
import com.xdja.pki.itsca.oer.asn1.EcSignature;
import com.xdja.pki.itsca.oer.asn1.EccPoint;
import com.xdja.pki.itsca.oer.asn1.EciesEncryptedKey;
import com.xdja.pki.itsca.oer.asn1.EncryptedData;
import com.xdja.pki.itsca.oer.asn1.HashAlgorithm;
import com.xdja.pki.itsca.oer.asn1.HashedId8;
import com.xdja.pki.itsca.oer.asn1.PKRecipientInfo;
import com.xdja.pki.itsca.oer.asn1.Payload;
import com.xdja.pki.itsca.oer.asn1.RecipientInfo;
import com.xdja.pki.itsca.oer.asn1.SecuredMessage;
import com.xdja.pki.itsca.oer.asn1.SequenceOfRecipientInfo;
import com.xdja.pki.itsca.oer.asn1.SymmetricCipherText;

public class EcSignatureBuilder {
    public static EcSignature build(SecuredMessage signedExternalPayload, byte[] key, Certificate ecaCertificate) throws Exception {
        EncryptedData encryptedData = new EncryptedData();
        byte[] cipher = GMSSLSymmetricEncryptUtils.symmetricECBEncryptBySdf((boolean)true, (SdfCryptoType)SdfCryptoType.YUNHSM, (SdfSymmetricKeyParameters.PaddingType)SdfSymmetricKeyParameters.PaddingType.PKCS7Padding, (byte[])key, (SdfAlgIdSymmetric)SdfAlgIdSymmetric.SGD_SM4_ECB, (byte[])signedExternalPayload.getEncode());
        CipherText cipherText = new CipherText();
        cipherText.setString(cipher);
        SymmetricCipherText symmetricCipherText = new SymmetricCipherText(cipherText);
        encryptedData.setCipherText(symmetricCipherText);
        SequenceOfRecipientInfo sequenceOfRecipientInfo = new SequenceOfRecipientInfo();
        PKRecipientInfo certRecipInfo = new PKRecipientInfo();
        HashAlgorithm hashAlg = new HashAlgorithm(HashAlgorithm.SGD_SM3);
        certRecipInfo.setHashAlg(hashAlg);
        byte[] certHash = GMSSLSM3DigestUtils.digestByBC((byte[])ecaCertificate.getEncode());
        byte[] certHashId8 = new byte[8];
        System.arraycopy(certHash, certHash.length - certHashId8.length, certHashId8, 0, certHashId8.length);
        HashedId8 recipientId = new HashedId8(certHashId8);
        certRecipInfo.setRecipientId(recipientId);
        EccPoint publicKey = ecaCertificate.getTbsCert().getSubjectAttribute().getEncryptionKey().getPublicKey();
        EciesEncryptedKey kek = KekBuilder.build(publicKey, key);
        certRecipInfo.setKek(kek);
        RecipientInfo recipientInfo = new RecipientInfo(certRecipInfo, PKRecipientInfoType.CERT_RECIPINFO);
        sequenceOfRecipientInfo.addRecipientInfo(recipientInfo);
        encryptedData.setRecipients(sequenceOfRecipientInfo);
        Payload payload = new Payload(encryptedData);
        EcSignature securedMessage = new EcSignature();
        securedMessage.setPayload(payload);
        return securedMessage;
    }
}

