/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.CipherText;
import com.xdja.pki.itsca.oer.asn1.base.OctetString;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AesCcmCipherText
extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(AesCcmCipherText.class);
    private OctetString nonce;
    private CipherText cipher;

    public AesCcmCipherText() {
        super(false, false);
    }

    public static AesCcmCipherText getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "AesCcmCipherText start data", data);
        OctetString nonce = new OctetString();
        byte[] goal = new byte[12];
        System.arraycopy(data, 0, goal, 0, goal.length);
        nonce.setString(goal);
        nonce.setLength(12);
        ByteArrayUtils.printHexBinary(logger, "AesCcmCipherText nonce", nonce.getEncode());
        goal = new byte[data.length - 12];
        System.arraycopy(data, 12, goal, 0, goal.length);
        data = goal;
        OctetString octetString = OctetString.getInstance(data);
        CipherText cipherText = new CipherText();
        cipherText.setString(octetString.getString());
        ByteArrayUtils.printHexBinary(logger, "AesCcmCipherText cipherText", cipherText.getEncode());
        data = octetString.getGoal();
        AesCcmCipherText aesCcmCipherText = new AesCcmCipherText();
        aesCcmCipherText.setCipher(cipherText);
        aesCcmCipherText.setNonce(nonce);
        aesCcmCipherText.setGoal(data);
        ByteArrayUtils.printHexBinary(logger, "AesCcmCipherText lave data", data);
        return aesCcmCipherText;
    }

    public void setNonce(OctetString nonce) {
        this.nonce = nonce;
    }

    public void setCipher(CipherText cipher) {
        this.cipher = cipher;
    }

    public void setNonce(byte[] nonce) {
        this.nonce = new OctetString();
        this.nonce.setLength(12);
        this.nonce.setString(nonce);
    }

    public OctetString getNonce() {
        return this.nonce;
    }

    public CipherText getCipher() {
        return this.cipher;
    }

    @Override
    public Vector getSequenceValues() {
        Vector<OctetString> vector = new Vector<OctetString>();
        vector.add(this.nonce);
        vector.add(this.cipher);
        return vector;
    }
}

