/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.Uncompressed;
import com.xdja.pki.itsca.oer.asn1.base.Choice;
import com.xdja.pki.itsca.oer.asn1.base.Null;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.asn1.base.OctetString;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import java.math.BigInteger;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EccPoint
extends Choice {
    private static Logger logger = LoggerFactory.getLogger(EccPoint.class);
    private OctetString xOnly;
    private Null fill;
    private OctetString compressedY0;
    private OctetString compressedY1;
    private Uncompressed uncompressed;

    public OctetString getxOnly() {
        return this.xOnly;
    }

    public static EccPoint getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "EccPoint start data ", data);
        EccPoint eccPoint = new EccPoint();
        BigInteger choice = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        if (choice.intValue() - 128 == 0) {
            byte[] xOnly = new byte[32];
            System.arraycopy(data, 1, xOnly, 0, xOnly.length);
            ByteArrayUtils.printHexBinary(logger, "EccPoint xOnly data ", xOnly);
            byte[] goal = new byte[data.length - xOnly.length - 1];
            System.arraycopy(data, xOnly.length + 1, goal, 0, goal.length);
            eccPoint.setxOnly(xOnly);
            eccPoint.setGoal(goal);
        } else if (choice.intValue() - 128 == 1) {
            logger.debug("EccPoint choice fill");
            eccPoint.setFill(new Null());
            eccPoint.setGoal(data);
        } else if (choice.intValue() - 128 == 2) {
            byte[] compressedY0 = new byte[32];
            System.arraycopy(data, 1, compressedY0, 0, compressedY0.length);
            ByteArrayUtils.printHexBinary(logger, "EccPoint compressedY0 data ", compressedY0);
            byte[] goal = new byte[data.length - compressedY0.length - 1];
            System.arraycopy(data, compressedY0.length + 1, goal, 0, goal.length);
            eccPoint.setCompressedY0(compressedY0);
            eccPoint.setGoal(goal);
        } else if (choice.intValue() - 128 == 3) {
            byte[] compressedY1 = new byte[32];
            System.arraycopy(data, 1, compressedY1, 0, compressedY1.length);
            ByteArrayUtils.printHexBinary(logger, "EccPoint compressedY1 data ", compressedY1);
            byte[] goal = new byte[data.length - compressedY1.length - 1];
            System.arraycopy(data, compressedY1.length + 1, goal, 0, goal.length);
            eccPoint.setCompressedY1(compressedY1);
            eccPoint.setGoal(goal);
        } else if (choice.intValue() - 128 == 4) {
            byte[] goal = new byte[data.length - 1];
            System.arraycopy(data, 1, goal, 0, goal.length);
            data = goal;
            Uncompressed uncompressed = Uncompressed.getInstance(data);
            ByteArrayUtils.printHexBinary(logger, "EccPoint Uncompressed data ", uncompressed.getEncode());
            eccPoint.setGoal(uncompressed.getGoal());
            eccPoint.setUncompressed(uncompressed);
        } else {
            logger.error("EccPoint choice is error " + choice.intValue());
            throw new Exception("unsupported eccpoint type " + choice.intValue());
        }
        ByteArrayUtils.printHexBinary(logger, "EccPoint lave data ", eccPoint.getGoal());
        return eccPoint;
    }

    public void setxOnly(OctetString xOnly) {
        this.xOnly = xOnly;
    }

    public void setxOnly(byte[] xOnly) {
        this.xOnly = new OctetString();
        this.xOnly.setLength(32);
        this.xOnly.setString(xOnly);
    }

    public Null getFill() {
        return this.fill;
    }

    public void setFill(Null fill) {
        this.addIndex(1);
        this.fill = fill;
    }

    public OctetString getCompressedY0() {
        return this.compressedY0;
    }

    public void setCompressedY0(OctetString compressedY0) {
        this.addIndex(2);
        this.compressedY0 = compressedY0;
    }

    public void setCompressedY0(byte[] compressedY0) {
        this.addIndex(2);
        this.compressedY0 = new OctetString();
        this.compressedY0.setString(compressedY0);
        this.compressedY0.setLength(32);
    }

    public OctetString getCompressedY1() {
        return this.compressedY1;
    }

    public void setCompressedY1(OctetString compressedY1) {
        this.addIndex(3);
        this.compressedY1 = compressedY1;
    }

    public void setCompressedY1(byte[] compressedY1) {
        this.addIndex(3);
        this.compressedY1 = new OctetString();
        this.compressedY1.setString(compressedY1);
        this.compressedY1.setLength(32);
    }

    public Uncompressed getUncompressed() {
        return this.uncompressed;
    }

    public void setUncompressed(Uncompressed uncompressed) {
        this.addIndex(4);
        this.uncompressed = uncompressed;
    }

    @Override
    public Vector getChoiceValues() {
        Vector<OERObject> vector = new Vector<OERObject>();
        vector.add(this.xOnly);
        vector.add(this.fill);
        vector.add(this.compressedY0);
        vector.add(this.compressedY1);
        vector.add(this.uncompressed);
        return vector;
    }
}

