/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.base.Enumerated;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashAlgorithm
extends Enumerated {
    private static Logger logger = LoggerFactory.getLogger(HashAlgorithm.class);
    public static final Enumerated.Value SGD_SM3 = new Enumerated.Value(0, "SGD_SM3");
    public static final Enumerated.Value SHA_256 = new Enumerated.Value(1, "SHA_256");

    public HashAlgorithm(Enumerated.Value value) {
        super(value);
        this.addValueToList(SGD_SM3);
        this.addValueToList(SHA_256);
    }

    public static HashAlgorithm getInstance(byte[] data) throws Exception {
        HashAlgorithm hashAlgorithm;
        ByteArrayUtils.printHexBinary(logger, "HashAlgorithm start data", data);
        BigInteger choice = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        if (choice.intValue() == 0) {
            logger.debug("HashAlgorithm choice SGD_SM3");
            hashAlgorithm = new HashAlgorithm(SGD_SM3);
        } else if (choice.intValue() == 1) {
            logger.debug("HashAlgorithm choice SHA_256");
            hashAlgorithm = new HashAlgorithm(SHA_256);
        } else {
            logger.error("HashAlgorithm choice is error " + choice.intValue());
            throw new Exception("unsupported HashAlgorithm type " + choice.intValue());
        }
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        hashAlgorithm.setGoal(goal);
        ByteArrayUtils.printHexBinary(logger, "HashAlgorithm lave data", data);
        return hashAlgorithm;
    }

    @Override
    public Enumerated.Value readValue() throws IOException {
        return super.readValue();
    }
}

