/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1.base;

import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;

public class OctetString
extends OERObject {
    private int length = -1;
    private byte[] string;

    public OctetString() {
    }

    public OctetString(int length) {
        this.length = length;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public byte[] getString() {
        return this.string;
    }

    public void setString(byte[] string) {
        this.string = this.length != -1 && string.length != this.length ? ByteArrayUtils.changeByteArrayLength(string, this.length) : string;
    }

    public static OctetString getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(null, "OctetString data", data);
        BigInteger length = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        OctetString opaque = new OctetString();
        if (length.intValue() - 128 > 0) {
            BigInteger len = BigIntegers.fromUnsignedByteArray((byte[])data, (int)1, (int)(length.intValue() - 128));
            byte[] goal = new byte[len.intValue()];
            System.arraycopy(data, 1 + (length.intValue() - 128), goal, 0, goal.length);
            ByteArrayUtils.printHexBinary(null, "OctetString real data", goal);
            opaque.setString(goal);
            byte[] dest = new byte[data.length - 1 - (length.intValue() - 128) - len.intValue()];
            System.arraycopy(data, 1 + (length.intValue() - 128) + len.intValue(), dest, 0, dest.length);
            opaque.setGoal(dest);
        } else if (length.intValue() - 128 < 0) {
            byte[] goal = new byte[length.intValue()];
            System.arraycopy(data, 1, goal, 0, goal.length);
            ByteArrayUtils.printHexBinary(null, "OctetString real data", goal);
            opaque.setString(goal);
            byte[] dest = new byte[data.length - 1 - length.intValue()];
            System.arraycopy(data, 1 + length.intValue(), dest, 0, dest.length);
            opaque.setGoal(dest);
        } else {
            throw new Exception("unsupported this oer OctetString  header  " + length.intValue());
        }
        return opaque;
    }

    public byte[] readString() throws IOException {
        int len = this.readInt();
        return this.readBytes(len);
    }

    public byte[] readString(int len) throws IOException {
        return this.readBytes(len);
    }

    @Override
    public Vector getValues() throws IOException {
        Vector<byte[]> vector = new Vector<byte[]>();
        if (this.length != -1) {
            if (this.string.length > this.length) {
                throw new IOException("string len:" + this.string.length + " is greater than " + this.length);
            }
        } else {
            this.setLengthPrefix(this.string.length);
        }
        vector.add(this.string);
        return vector;
    }
}

