/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.cert;

import com.xdja.pki.itsca.oer.asn1.EccPoint;
import com.xdja.pki.itsca.oer.asn1.Uncompressed;
import com.xdja.pki.itsca.oer.asn1.base.OctetString;
import com.xdja.pki.itsca.oer.cert.bean.EccPointType;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;

public class EccPointBuilder {
    public static EccPoint build(PublicKey publicKey, EccPointType eccPointType) throws Exception {
        if (eccPointType == EccPointType.UNCOMPRESSED) {
            return EccPointBuilder.buildWithUnCompressed(publicKey);
        }
        if (eccPointType == EccPointType.COMPRESSED_Y || eccPointType == EccPointType.COMPRESSED_Y0 || eccPointType == EccPointType.COMPRESSED_Y1) {
            return EccPointBuilder.buildWithCompressed(publicKey);
        }
        if (eccPointType != EccPointType.X_ONLY && eccPointType != EccPointType.FILL) {
            throw new Exception("unsupported this eccpoint type id =  " + eccPointType.id + " value = " + eccPointType.value);
        }
        return null;
    }

    private static EccPoint buildWithUnCompressed(PublicKey publicKey) throws Exception {
        EccPoint eccPoint = new EccPoint();
        Uncompressed uncompressed = new Uncompressed();
        ECPublicKey ecPublicKey = (ECPublicKey)publicKey;
        byte[] x = ByteArrayUtils.changeByteArrayLength(ecPublicKey.getW().getAffineX());
        byte[] y = ByteArrayUtils.changeByteArrayLength(ecPublicKey.getW().getAffineY());
        ByteArrayUtils.printHexBinary(5, "x OCTET STRING", null);
        ByteArrayUtils.printHexBinary(5, "x", x);
        uncompressed.setX(x);
        ByteArrayUtils.printHexBinary(5, "y OCTET STRING", null);
        ByteArrayUtils.printHexBinary(5, "y", y);
        uncompressed.setY(y);
        ByteArrayUtils.printHexBinary(5, "Uncompressed", uncompressed.getEncode());
        eccPoint.setUncompressed(uncompressed);
        return eccPoint;
    }

    private static EccPoint buildWithCompressed(PublicKey publicKey) throws Exception {
        EccPoint eccPoint = new EccPoint();
        OctetString compressed = new OctetString();
        ECPublicKey ecPublicKey = (ECPublicKey)publicKey;
        byte[] x = ByteArrayUtils.changeByteArrayLength(ecPublicKey.getW().getAffineX());
        BigInteger y = ecPublicKey.getW().getAffineY();
        compressed.setString(x);
        compressed.setLength(32);
        if (y.testBit(0)) {
            eccPoint.setCompressedY1(compressed);
        } else {
            eccPoint.setCompressedY0(compressed);
        }
        ByteArrayUtils.printHexBinary(5, "compressed ", x);
        return eccPoint;
    }
}

