/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.cert;

import com.xdja.pki.itsca.oer.asn1.EccCurve;
import com.xdja.pki.itsca.oer.asn1.EccPoint;
import com.xdja.pki.itsca.oer.asn1.GeographicRegion;
import com.xdja.pki.itsca.oer.asn1.PublicEncryptionKey;
import com.xdja.pki.itsca.oer.asn1.PublicVerifyKey;
import com.xdja.pki.itsca.oer.asn1.SequenceOfItsAidList;
import com.xdja.pki.itsca.oer.asn1.SequenceOfItsAidSspList;
import com.xdja.pki.itsca.oer.asn1.SubjectAttribute;
import com.xdja.pki.itsca.oer.asn1.SubjectInfo;
import com.xdja.pki.itsca.oer.asn1.SubjectType;
import com.xdja.pki.itsca.oer.asn1.SymmetricAlgorithm;
import com.xdja.pki.itsca.oer.asn1.TbsCert;
import com.xdja.pki.itsca.oer.asn1.Time32;
import com.xdja.pki.itsca.oer.asn1.TimeStartAndEnd;
import com.xdja.pki.itsca.oer.asn1.ValidityPeriod;
import com.xdja.pki.itsca.oer.asn1.ValidityRestriction;
import com.xdja.pki.itsca.oer.asn1.base.Enumerated;
import com.xdja.pki.itsca.oer.cert.EccPointBuilder;
import com.xdja.pki.itsca.oer.cert.bean.EccPointType;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import com.xdja.pki.itsca.oer.utils.TimeUtils;
import java.io.IOException;
import java.security.PublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TbsCertBuilder {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private SequenceOfItsAidList itsAidList;
    private SequenceOfItsAidSspList itsAidSspList;
    private GeographicRegion geographicRegion;
    private Time32 startTime;
    private Time32 endTime;
    private EccPointType signKeyEccPointType = EccPointType.UNCOMPRESSED;
    private EccPointType encKeyEccPointType = EccPointType.UNCOMPRESSED;

    public void setSignKeyEccPointType(EccPointType signKeyEccPointType) {
        this.signKeyEccPointType = signKeyEccPointType;
    }

    public void setEncKeyEccPointType(EccPointType encKeyEccPointType) {
        this.encKeyEccPointType = encKeyEccPointType;
    }

    public void setStartTime(Time32 startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Time32 endTime) {
        this.endTime = endTime;
    }

    public void setItsAidList(SequenceOfItsAidList itsAidList) {
        this.itsAidList = itsAidList;
    }

    public void setItsAidSspList(SequenceOfItsAidSspList itsAidSspList) {
        this.itsAidSspList = itsAidSspList;
    }

    public void setGeographicRegion(GeographicRegion geographicRegion) {
        this.geographicRegion = geographicRegion;
    }

    public TbsCert build(PublicKey verifyPublicKey, PublicKey encPublicKey, String subjectName, Enumerated.Value subjectTypeValue) throws Exception {
        return this.build(verifyPublicKey, encPublicKey, subjectName.getBytes(), subjectTypeValue);
    }

    public TbsCert build(PublicKey verifyPublicKey, PublicKey encPublicKey, byte[] subjectName, Enumerated.Value subjectTypeValue) throws Exception {
        TbsCert tbsCert = new TbsCert();
        this.buildSubjectInfo(tbsCert, subjectName, subjectTypeValue);
        this.buildSubjectAttribute(tbsCert, verifyPublicKey, encPublicKey);
        this.buildValidityRestriction(tbsCert);
        return tbsCert;
    }

    public void buildSubjectInfo(TbsCert tbsCert, String subjectName, Enumerated.Value subjectTypeValue) throws IOException {
        this.buildSubjectInfo(tbsCert, subjectName.getBytes(), subjectTypeValue);
    }

    public void buildSubjectInfo(TbsCert tbsCert, byte[] subjectName, Enumerated.Value subjectTypeValue) throws IOException {
        ByteArrayUtils.printHexBinary(2, "SubjectInfo SEQUENCE", null);
        SubjectInfo subjectInfo = new SubjectInfo();
        ByteArrayUtils.printHexBinary(3, "SubjectType ENUMERATED [" + subjectTypeValue.getIndex() + " " + subjectTypeValue.getDesc() + "]", null);
        SubjectType subjectType = new SubjectType(subjectTypeValue);
        subjectInfo.setSubjectType(subjectType);
        ByteArrayUtils.printHexBinary(3, "SubjectType", subjectInfo.getEncode());
        ByteArrayUtils.printHexBinary(3, "SubjectName OCTET STRING [" + subjectName + "]", null);
        ByteArrayUtils.printHexBinary(3, "SubjectName", subjectName);
        subjectInfo.setSubjectName(subjectName);
        ByteArrayUtils.printHexBinary(2, "SubjectInfo", subjectInfo.getEncode());
        tbsCert.setSubjectInfo(subjectInfo);
    }

    public void buildSubjectAttribute(TbsCert tbsCert, PublicKey verifyPublicKey, PublicKey encPublicKey) throws Exception {
        ByteArrayUtils.printHexBinary(2, "SubjectAttribute SEQUENCE", null);
        SubjectAttribute subjectAttribute = new SubjectAttribute();
        ByteArrayUtils.printHexBinary(3, "PublicVerifyKey SEQUENCE", null);
        PublicVerifyKey verifyKey = new PublicVerifyKey();
        Enumerated.Value sgdSm2 = EccCurve.SGD_SM2;
        ByteArrayUtils.printHexBinary(4, "EccCurve ENUMERATED [" + sgdSm2.getIndex() + " " + sgdSm2.getDesc() + "]", null);
        EccCurve eccCurve = new EccCurve(sgdSm2);
        verifyKey.setEccCurve(eccCurve);
        ByteArrayUtils.printHexBinary(4, "EccCurve", eccCurve.getEncode());
        ByteArrayUtils.printHexBinary(4, "EccPoint CHOICE [index = 4] ", null);
        ByteArrayUtils.printHexBinary(5, "Uncompressed SEQUENCE", null);
        EccPoint signEcc = EccPointBuilder.build(verifyPublicKey, this.signKeyEccPointType);
        verifyKey.setEccPoint(signEcc);
        ByteArrayUtils.printHexBinary(4, "EccPoint", signEcc.getEncode());
        subjectAttribute.setVerifyKey(verifyKey);
        ByteArrayUtils.printHexBinary(3, "PublicVerifyKey", verifyKey.getEncode());
        if (null != encPublicKey) {
            PublicEncryptionKey encryptionKey = new PublicEncryptionKey();
            encryptionKey.setSupportedSymmAlg(new SymmetricAlgorithm(SymmetricAlgorithm.SGD_SM4_ECB));
            encryptionKey.setEccCurve(new EccCurve(EccCurve.SGD_SM2));
            EccPoint encEcc = EccPointBuilder.build(encPublicKey, this.encKeyEccPointType);
            encryptionKey.setPublicKey(encEcc);
            subjectAttribute.setEncryptionKey(encryptionKey);
        }
        if (this.itsAidList != null) {
            ByteArrayUtils.printHexBinary(3, "SequenceOfItsAidList SEQUENCE OF ItsAid", null);
            subjectAttribute.setItsAidList(this.itsAidList);
            ByteArrayUtils.printHexBinary(3, "SequenceOfItsAidList", this.itsAidList.getEncode());
        }
        if (this.itsAidSspList != null) {
            ByteArrayUtils.printHexBinary(3, "SequenceOfItsAidSspList SEQUENCE OF ItsAidSsp", null);
            subjectAttribute.setItsSspList(this.itsAidSspList);
            ByteArrayUtils.printHexBinary(3, "SequenceOfItsAidSspList", this.itsAidSspList.getEncode());
        }
        tbsCert.setSubjectAttribute(subjectAttribute);
        ByteArrayUtils.printHexBinary(2, "SubjectAttribute", subjectAttribute.getEncode());
    }

    public void buildValidityRestriction(TbsCert tbsCert) throws IOException {
        ByteArrayUtils.printHexBinary(2, "ValidityRestriction SEQUENCE", null);
        ValidityRestriction validityRestriction = new ValidityRestriction();
        ByteArrayUtils.printHexBinary(3, "ValidityPeriod CHOICE [index=0]", null);
        ValidityPeriod validityPeriod = new ValidityPeriod();
        ByteArrayUtils.printHexBinary(4, "Time32 INTEGER", null);
        TimeStartAndEnd startAndEnd = new TimeStartAndEnd();
        if (null == this.endTime) {
            long nowTime = TimeUtils.getNowTime();
            Time32 time32 = new Time32(nowTime);
            startAndEnd.setStartValidity(time32);
            ByteArrayUtils.printHexBinary(4, "Time32 start", time32.getEncode());
            long timeEnd = TimeUtils.getTimeAfterYear(1);
            time32 = new Time32(timeEnd);
            startAndEnd.setEndValidity(time32);
            validityPeriod.setTimeStartAndEnd(startAndEnd);
            ByteArrayUtils.printHexBinary(4, "Time32 end ", time32.getEncode());
        } else if (null == this.startTime) {
            validityPeriod.setTimeEnd(this.endTime);
        } else {
            startAndEnd = new TimeStartAndEnd();
            startAndEnd.setStartValidity(this.startTime);
            startAndEnd.setEndValidity(this.endTime);
            validityPeriod.setTimeStartAndEnd(startAndEnd);
        }
        ByteArrayUtils.printHexBinary(3, "ValidityPeriod", validityPeriod.getEncode());
        validityRestriction.setValidityPeriod(validityPeriod);
        if (this.geographicRegion != null) {
            ByteArrayUtils.printHexBinary(3, "GeographicRegion CHOICE [index=]", validityPeriod.getEncode());
            validityRestriction.setGeographicRegion(this.geographicRegion);
            ByteArrayUtils.printHexBinary(3, "GeographicRegion", validityPeriod.getEncode());
        }
        tbsCert.setValidityRestriction(validityRestriction);
        ByteArrayUtils.printHexBinary(2, "ValidityRestriction", validityRestriction.getEncode());
    }
}

