/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.app;

import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2SignUtils;
import com.xdja.pki.itsca.oer.asn1.EccCurve;
import com.xdja.pki.itsca.oer.asn1.Signature;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.utils.BCUtils;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import java.security.PrivateKey;

public class SignatureBuild {
    public static Signature build(PrivateKey privateKey, OERObject tobeSign) throws Exception {
        return SignatureBuild.build(privateKey, tobeSign.getEncode());
    }

    public static Signature build(PrivateKey privateKey, byte[] data) throws Exception {
        byte[] s;
        byte[] r;
        try {
            byte[] sign = privateKey instanceof SdfPrivateKey ? GMSSLSM2SignUtils.signBySdfWithUserId((SdfCryptoType)SdfCryptoType.YUNHSM, (int)((SdfPrivateKey)privateKey).getIndex(), (String)new String(((SdfPrivateKey)privateKey).getPassword()), (byte[])"China".getBytes(), (byte[])data) : BCUtils.sm2SignByBC(privateKey, data);
            byte[][] derDecode = BCUtils.sm2SignDerDecode(sign);
            assert (derDecode != null && derDecode.length == 2);
            r = derDecode[0];
            s = derDecode[1];
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        ByteArrayUtils.printHexBinary(3, "Signature", null);
        Signature signature = new Signature();
        EccCurve eccCurve = new EccCurve(EccCurve.SGD_SM2);
        ByteArrayUtils.printHexBinary(4, "EccCurve", null);
        ByteArrayUtils.printHexBinary(5, "EccCurve  SGD_SM2", null);
        signature.setEccCurve(eccCurve);
        signature.setR(r);
        ByteArrayUtils.printHexBinary(4, "r", r);
        signature.setS(s);
        ByteArrayUtils.printHexBinary(4, "s", s);
        return signature;
    }
}

