/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.CircularRegion;
import com.xdja.pki.itsca.oer.asn1.PolygonalRegion;
import com.xdja.pki.itsca.oer.asn1.SequenceOfRectangularRegion;
import com.xdja.pki.itsca.oer.asn1.base.Choice;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import java.math.BigInteger;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeographicRegion
extends Choice {
    private static Logger logger = LoggerFactory.getLogger(GeographicRegion.class);
    private CircularRegion circularRegion;
    private SequenceOfRectangularRegion rectangularRegion;
    private PolygonalRegion polygonalRegion;

    public CircularRegion getCircularRegion() {
        return this.circularRegion;
    }

    public static GeographicRegion getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "GeographicRegion start data", data);
        BigInteger choice = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        GeographicRegion geographicRegion = new GeographicRegion();
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        data = goal;
        if (choice.intValue() - 128 == 0) {
            logger.debug("GeographicRegion choice circularRegion");
            CircularRegion circularRegion = CircularRegion.getInstance(data);
            ByteArrayUtils.printHexBinary(logger, "GeographicRegion circularRegion data", circularRegion.getEncode());
            geographicRegion.setCircularRegion(circularRegion);
            data = circularRegion.getGoal();
        } else if (choice.intValue() - 128 == 1) {
            logger.debug("GeographicRegion choice rectangularRegion");
            SequenceOfRectangularRegion instance = SequenceOfRectangularRegion.getInstance(data);
            ByteArrayUtils.printHexBinary(logger, "GeographicRegion rectangularRegion data", instance.getEncode());
            geographicRegion.setRectangularRegion(instance);
            data = instance.getGoal();
        } else if (choice.intValue() - 128 == 2) {
            logger.debug("GeographicRegion choice polygonalRegion");
            PolygonalRegion polygonalRegion = PolygonalRegion.getInstance(data);
            ByteArrayUtils.printHexBinary(logger, "GeographicRegion polygonalRegion data", polygonalRegion.getEncode());
            geographicRegion.setPolygonalRegion(polygonalRegion);
            data = polygonalRegion.getGoal();
        } else {
            logger.error("GeographicRegion choice is error" + choice.intValue());
            throw new Exception("GeographicRegion unSupport choice " + choice.intValue());
        }
        geographicRegion.setGoal(data);
        ByteArrayUtils.printHexBinary(logger, "GeographicRegion lave data", data);
        return geographicRegion;
    }

    public void setCircularRegion(CircularRegion circularRegion) {
        this.circularRegion = circularRegion;
    }

    public SequenceOfRectangularRegion getRectangularRegion() {
        return this.rectangularRegion;
    }

    public void setRectangularRegion(SequenceOfRectangularRegion rectangularRegion) {
        this.addIndex(1);
        this.rectangularRegion = rectangularRegion;
    }

    public PolygonalRegion getPolygonalRegion() {
        return this.polygonalRegion;
    }

    public void setPolygonalRegion(PolygonalRegion polygonalRegion) {
        this.addIndex(2);
        this.polygonalRegion = polygonalRegion;
    }

    @Override
    public Vector getChoiceValues() {
        Vector<OERObject> vector = new Vector<OERObject>();
        vector.add(this.circularRegion);
        vector.add(this.rectangularRegion);
        vector.add(this.polygonalRegion);
        return vector;
    }
}

