/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.ItsAid;
import com.xdja.pki.itsca.oer.asn1.base.BitByte;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.asn1.base.OctetString;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.util.BitArray;

public class ItsAidSsp
extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(ItsAidSsp.class);
    private ItsAid itsAid;
    private OctetString serviceSpecificPermissions;

    public ItsAidSsp() {
        super(false, false);
    }

    public static ItsAidSsp getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "ItsAidSsp start data", data);
        ItsAid itsAid = ItsAid.getInstance(data);
        data = itsAid.getGoal();
        ByteArrayUtils.printHexBinary(logger, "ItsAidSsp itsAid data", itsAid.getEncode());
        OctetString octetString = OctetString.getInstance(data);
        OctetString serviceSpecificPermissions = new OctetString();
        serviceSpecificPermissions.setString(octetString.getString());
        data = octetString.getGoal();
        ByteArrayUtils.printHexBinary(logger, "ItsAidSsp serviceSpecificPermissions data", serviceSpecificPermissions.getEncode());
        ItsAidSsp itsAidSsp = new ItsAidSsp();
        itsAidSsp.setServiceSpecificPermissions(serviceSpecificPermissions);
        itsAidSsp.setItsAid(itsAid);
        itsAidSsp.setGoal(data);
        ByteArrayUtils.printHexBinary(logger, "ItsAidSsp lave data", itsAidSsp.getGoal());
        return itsAidSsp;
    }

    public ItsAid getItsAid() {
        return this.itsAid;
    }

    public OctetString getServiceSpecificPermissions() {
        return this.serviceSpecificPermissions;
    }

    public List<Integer> getServiceSpecificPermissionsList() throws Exception {
        byte[] string = this.serviceSpecificPermissions.getString();
        byte[] b = new byte[string.length - 1];
        System.arraycopy(string, 1, b, 0, string.length - 1);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < b.length; ++i) {
            BitByte bitByte = BitByte.setBit(b[i] & 0xFF);
            List<Integer> list1 = bitByte.readIndexes();
            for (Integer j : list1) {
                list.add(j + 1 + 8 * i);
            }
        }
        return list;
    }

    public void setItsAid(ItsAid itsAid) {
        this.itsAid = itsAid;
    }

    public void setServiceSpecificPermissions(OctetString serviceSpecificPermissions) {
        this.serviceSpecificPermissions = serviceSpecificPermissions;
    }

    public void setServiceSpecificPermissions(byte[] serviceSpecificPermissions) throws IOException {
        this.serviceSpecificPermissions = new OctetString();
        this.serviceSpecificPermissions.setString(serviceSpecificPermissions);
    }

    public void setServiceSpecificPermissions(List<Integer> list) throws IOException {
        this.serviceSpecificPermissions = new OctetString();
        if (null == list) {
            this.serviceSpecificPermissions.setString(new byte[]{1});
        } else {
            Collections.sort(list);
            int sspMax = list.get(list.size() - 1);
            if (sspMax > 248) {
                throw new IOException("ssp max is too long " + sspMax);
            }
            int offset = sspMax % 8 == 0 ? 0 : 8 - sspMax % 8;
            int len = sspMax + offset;
            logger.debug("ssp bit len is {}", (Object)len);
            boolean[] bs = new boolean[len];
            for (int i = 1; i < len + 1; ++i) {
                bs[i - 1] = list.contains(i);
            }
            BitArray bitArray = new BitArray(bs);
            byte[] bytes = bitArray.toByteArray();
            ByteArrayUtils.printHexBinary(logger, "serviceSpecificPermissions", bitArray.toByteArray());
            this.serviceSpecificPermissions = new OctetString();
            byte[] data = new byte[]{1};
            byte[] serviceSpecificPermissions = ByteArrayUtils.buildUpByte(data, bytes);
            this.serviceSpecificPermissions.setString(serviceSpecificPermissions);
        }
    }

    @Override
    public Vector getSequenceValues() {
        Vector<OERObject> vector = new Vector<OERObject>();
        vector.add(this.itsAid);
        vector.add(this.serviceSpecificPermissions);
        return vector;
    }
}

