/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.Time32;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.asn1.base.OctetString;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PseudonymCertDownloadRequest
extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(PseudonymCertDownloadRequest.class);
    private Time32 timestamp;
    private OctetString requestHash;

    public PseudonymCertDownloadRequest() {
        super(false, false);
    }

    public static PseudonymCertDownloadRequest getInstance(byte[] data) throws Exception {
        Time32 timestamp = Time32.getInstance(data);
        data = timestamp.getGoal();
        ByteArrayUtils.printHexBinary(logger, "PseudonymCertDownloadRequest requestHash data", timestamp.getEncode());
        OctetString requestHash = new OctetString();
        requestHash.setLength(32);
        byte[] request = new byte[32];
        System.arraycopy(data, 0, request, 0, request.length);
        requestHash.setString(request);
        byte[] goal = new byte[data.length - 32];
        System.arraycopy(data, 32, goal, 0, goal.length);
        PseudonymCertDownloadRequest certDownloadRequest = new PseudonymCertDownloadRequest();
        certDownloadRequest.setRequestHash(requestHash);
        certDownloadRequest.setTimestamp(timestamp);
        certDownloadRequest.setGoal(goal);
        ByteArrayUtils.printHexBinary(logger, "PseudonymCertDownloadRequest lave data", goal);
        return certDownloadRequest;
    }

    public Time32 getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Time32 timestamp) {
        this.timestamp = timestamp;
    }

    public OctetString getRequestHash() {
        return this.requestHash;
    }

    public void setRequestHash(OctetString requestHash) {
        this.requestHash = requestHash;
    }

    public void setRequestHash(byte[] data) {
        this.requestHash = new OctetString();
        this.requestHash.setString(data);
        this.requestHash.setLength(32);
    }

    @Override
    public Vector getSequenceValues() {
        Vector<OERObject> vector = new Vector<OERObject>();
        vector.add(this.timestamp);
        vector.add(this.requestHash);
        return vector;
    }
}

