/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.Time32;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.asn1.base.OctetString;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PseudonymCertProvisioningAck
extends Sequence {
    private static Logger logger = LoggerFactory.getLogger(PseudonymCertProvisioningAck.class);
    private OctetString requestHash;
    private Time32 certDLTime;
    private OctetString certDLURL;

    public PseudonymCertProvisioningAck() {
        super(false, false);
    }

    public static PseudonymCertProvisioningAck getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "PseudonymCertProvisioningAck start data", data);
        OctetString requestHash = new OctetString();
        requestHash.setLength(32);
        byte[] request = new byte[32];
        System.arraycopy(data, 0, request, 0, request.length);
        requestHash.setString(request);
        byte[] goal = new byte[data.length - 32];
        System.arraycopy(data, 32, goal, 0, goal.length);
        data = goal;
        ByteArrayUtils.printHexBinary(logger, "PseudonymCertProvisioningAck requestHash data", requestHash.getEncode());
        Time32 certDLTime = Time32.getInstance(data);
        data = certDLTime.getGoal();
        ByteArrayUtils.printHexBinary(logger, "PseudonymCertProvisioningAck certDLTime  data", certDLTime.getEncode());
        OctetString certDLURL = OctetString.getInstance(data);
        data = certDLURL.getGoal();
        ByteArrayUtils.printHexBinary(logger, "PublicEncryptionKey eccPoint data", certDLURL.getEncode());
        PseudonymCertProvisioningAck provisioningAck = new PseudonymCertProvisioningAck();
        provisioningAck.setRequestHash(requestHash);
        provisioningAck.setCertDLTime(certDLTime);
        provisioningAck.setCertDLURL(certDLURL);
        provisioningAck.setGoal(data);
        ByteArrayUtils.printHexBinary(logger, "PublicEncryptionKey lave data", provisioningAck.getGoal());
        return provisioningAck;
    }

    public OctetString getRequestHash() {
        return this.requestHash;
    }

    public void setRequestHash(OctetString requestHash) {
        this.requestHash = requestHash;
    }

    public void setRequestHash(byte[] data) {
        this.requestHash = new OctetString();
        this.requestHash.setString(data);
        this.requestHash.setLength(32);
    }

    public Time32 getCertDLTime() {
        return this.certDLTime;
    }

    public void setCertDLTime(Time32 certDLTime) {
        this.certDLTime = certDLTime;
    }

    public OctetString getCertDLURL() {
        return this.certDLURL;
    }

    public void setCertDLURL(OctetString certDLURL) {
        this.certDLURL = certDLURL;
    }

    @Override
    public Vector getSequenceValues() {
        Vector<OERObject> vector = new Vector<OERObject>();
        vector.add(this.requestHash);
        vector.add(this.certDLTime);
        vector.add(this.certDLURL);
        return vector;
    }
}

