/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1;

import com.xdja.pki.itsca.oer.asn1.Time32;
import com.xdja.pki.itsca.oer.asn1.TimeStartAndEnd;
import com.xdja.pki.itsca.oer.asn1.base.Choice;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import java.math.BigInteger;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidityPeriod
extends Choice {
    private static Logger logger = LoggerFactory.getLogger(ValidityPeriod.class);
    private Time32 timeEnd;
    private TimeStartAndEnd timeStartAndEnd;

    public static ValidityPeriod getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "ValidityPeriod start data ", data);
        ValidityPeriod validityPeriod = new ValidityPeriod();
        BigInteger choice = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        if (choice.intValue() - 128 == 0) {
            logger.debug("ValidityPeriod choice timeEnd");
            BigInteger time = BigIntegers.fromUnsignedByteArray((byte[])data, (int)1, (int)4);
            Time32 time32 = new Time32(time.longValue());
            byte[] goal = new byte[data.length - 1 - 4];
            System.arraycopy(data, 5, goal, 0, goal.length);
            data = goal;
            ByteArrayUtils.printHexBinary(logger, "ValidityPeriod timeEnd data ", time32.getEncode());
            validityPeriod.setTimeEnd(time32);
            validityPeriod.setGoal(data);
        } else if (choice.intValue() - 128 == 1) {
            logger.debug("ValidityPeriod choice timeStartAndEnd");
            byte[] goal = new byte[data.length - 1];
            System.arraycopy(data, 1, goal, 0, goal.length);
            data = goal;
            TimeStartAndEnd timeStartAndEnd = TimeStartAndEnd.getInstance(data);
            validityPeriod.setTimeStartAndEnd(timeStartAndEnd);
            validityPeriod.setGoal(timeStartAndEnd.getGoal());
            ByteArrayUtils.printHexBinary(logger, "ValidityPeriod timeEnd data ", timeStartAndEnd.getEncode());
        } else {
            logger.error("ValidityPeriod choice is error " + choice.intValue());
            throw new Exception("unsupported ValidityPeriod type " + choice.intValue());
        }
        ByteArrayUtils.printHexBinary(logger, "ValidityPeriod lave data ", validityPeriod.getGoal());
        return validityPeriod;
    }

    public Time32 getTimeEnd() {
        return this.timeEnd;
    }

    public void setTimeEnd(Time32 timeEnd) {
        this.timeEnd = timeEnd;
    }

    public TimeStartAndEnd getTimeStartAndEnd() {
        return this.timeStartAndEnd;
    }

    public void setTimeStartAndEnd(TimeStartAndEnd timeStartAndEnd) {
        this.addIndex(1);
        this.timeStartAndEnd = timeStartAndEnd;
    }

    @Override
    public Vector getChoiceValues() {
        Vector<OERObject> vector = new Vector<OERObject>();
        vector.add(this.timeEnd);
        vector.add(this.timeStartAndEnd);
        return vector;
    }
}

