/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1.base;

import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Uint32
extends OERObject {
    protected static Logger logger = LoggerFactory.getLogger(Uint32.class);
    protected byte[] bytes;

    public Uint32(long i) throws IOException {
        if (i > 0xFFFFFFFFL || i < 0L) {
            throw new IOException("Uint32 must in 0-4294967295L");
        }
        this.bytes = ByteBuffer.allocate(4).putInt((int)i).array();
    }

    private Uint32() {
    }

    public static Uint32 getInstance(byte[] data) throws Exception {
        ByteArrayUtils.printHexBinary(logger, "lave data", data);
        BigInteger integer = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)4);
        Uint32 uint32 = new Uint32(integer.longValue());
        byte[] goal = new byte[data.length - 4];
        System.arraycopy(data, 4, goal, 0, goal.length);
        uint32.setGoal(goal);
        return uint32;
    }

    @Override
    public Vector getValues() throws IOException {
        Vector<byte[]> vector = new Vector<byte[]>();
        vector.add(this.bytes);
        return vector;
    }
}

