/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1.scms.lccf;

import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.asn1.base.Uint16;
import com.xdja.pki.itsca.oer.asn1.scms.lccf.LocalCertificateChainFile;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;

public class LCCFDownLoad
extends Sequence {
    private Uint16 code;
    private LocalCertificateChainFile fileContent;

    public LCCFDownLoad(boolean isExtension, boolean hasOptional) {
        super(isExtension, hasOptional);
    }

    public LCCFDownLoad() {
        super(false, false);
    }

    public static LCCFDownLoad getInstance(byte[] data) throws Exception {
        LCCFDownLoad lccfDownLoad = new LCCFDownLoad();
        byte[] codeBytes = new byte[2];
        System.arraycopy(data, 0, codeBytes, 0, codeBytes.length);
        lccfDownLoad.setCode(new Uint16(BigIntegers.fromUnsignedByteArray((byte[])codeBytes).intValue()));
        byte[] goal = new byte[data.length - codeBytes.length];
        System.arraycopy(data, 2, goal, 0, goal.length);
        LocalCertificateChainFile localCertificateChainFile = LocalCertificateChainFile.getInstance(goal);
        lccfDownLoad.setFileContent(localCertificateChainFile);
        lccfDownLoad.setGoal(localCertificateChainFile.getGoal());
        return lccfDownLoad;
    }

    public Uint16 getCode() {
        return this.code;
    }

    public void setCode(Uint16 code) {
        this.code = code;
    }

    public LocalCertificateChainFile getFileContent() {
        return this.fileContent;
    }

    public void setFileContent(LocalCertificateChainFile fileContent) {
        this.fileContent = fileContent;
    }

    @Override
    public Vector getSequenceValues() {
        Vector<OERObject> vector = new Vector<OERObject>();
        vector.add(this.code);
        vector.add(this.fileContent);
        return vector;
    }
}

