/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1.scms.lpf;

import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.asn1.base.Uint16;
import com.xdja.pki.itsca.oer.asn1.base.Uint8;
import com.xdja.pki.itsca.oer.asn1.scms.lpf.Duration;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;

public class GlobalPolicyData
extends Sequence {
    private Uint8 itscaVersion;
    private Uint16 gpfVersion;
    private Duration ecPeriod;
    private Duration ecApplyEarlierTime;
    private Duration pcIPeriod;
    private Duration pcApplyEarlierTime;
    private Duration pcOverlapTime;
    private Uint8 pcMinCertsPerIPeriod;
    private Duration pcUseSwitchTime;
    private Uint8 pcUseSwitchAlgorithm;

    public GlobalPolicyData() {
        super(false, false);
    }

    public GlobalPolicyData(boolean isExtension, boolean hasOptional) {
        super(isExtension, hasOptional);
    }

    public Uint8 getItscaVersion() {
        return this.itscaVersion;
    }

    public void setItscaVersion(Uint8 itscaVersion) {
        this.itscaVersion = itscaVersion;
    }

    public Duration getEcPeriod() {
        return this.ecPeriod;
    }

    public void setEcPeriod(Duration ecPeriod) {
        this.ecPeriod = ecPeriod;
    }

    public Duration getEcApplyEarlierTime() {
        return this.ecApplyEarlierTime;
    }

    public void setEcApplyEarlierTime(Duration ecApplyEarlierTime) {
        this.ecApplyEarlierTime = ecApplyEarlierTime;
    }

    public Duration getPcIPeriod() {
        return this.pcIPeriod;
    }

    public void setPcIPeriod(Duration pcIPeriod) {
        this.pcIPeriod = pcIPeriod;
    }

    public Duration getPcApplyEarlierTime() {
        return this.pcApplyEarlierTime;
    }

    public void setPcApplyEarlierTime(Duration pcApplyEarlierTime) {
        this.pcApplyEarlierTime = pcApplyEarlierTime;
    }

    public Duration getPcOverlapTime() {
        return this.pcOverlapTime;
    }

    public void setPcOverlapTime(Duration pcOverlapTime) {
        this.pcOverlapTime = pcOverlapTime;
    }

    public Uint8 getPcMinCertsPerIPeriod() {
        return this.pcMinCertsPerIPeriod;
    }

    public void setPcMinCertsPerIPeriod(Uint8 pcMinCertsPerIPeriod) {
        this.pcMinCertsPerIPeriod = pcMinCertsPerIPeriod;
    }

    public Duration getPcUseSwitchTime() {
        return this.pcUseSwitchTime;
    }

    public void setPcUseSwitchTime(Duration pcUseSwitchTime) {
        this.pcUseSwitchTime = pcUseSwitchTime;
    }

    public Uint8 getPcUseSwitchAlgorithm() {
        return this.pcUseSwitchAlgorithm;
    }

    public void setPcUseSwitchAlgorithm(Uint8 pcUseSwitchAlgorithm) {
        this.pcUseSwitchAlgorithm = pcUseSwitchAlgorithm;
    }

    public Uint16 getGpfVersion() {
        return this.gpfVersion;
    }

    public void setGpfVersion(Uint16 gpfVersion) {
        this.gpfVersion = gpfVersion;
    }

    public static GlobalPolicyData getInstance(byte[] data) throws Exception {
        GlobalPolicyData globalPolicyData = new GlobalPolicyData();
        byte[] itscaVersionBytes = new byte[1];
        System.arraycopy(data, 0, itscaVersionBytes, 0, itscaVersionBytes.length);
        globalPolicyData.setItscaVersion(new Uint8(BigIntegers.fromUnsignedByteArray((byte[])itscaVersionBytes).intValue()));
        byte[] gpfVersionBytes = new byte[2];
        System.arraycopy(data, 1, gpfVersionBytes, 0, gpfVersionBytes.length);
        globalPolicyData.setGpfVersion(new Uint16(BigIntegers.fromUnsignedByteArray((byte[])gpfVersionBytes).intValue()));
        byte[] goal = new byte[data.length - 3];
        System.arraycopy(data, 3, goal, 0, goal.length);
        Duration ecPeriod = Duration.getInstance(goal);
        globalPolicyData.setEcPeriod(ecPeriod);
        Duration ecApplyEarlierTime = Duration.getInstance(ecPeriod.getGoal());
        globalPolicyData.setEcApplyEarlierTime(ecApplyEarlierTime);
        Duration pcIPeriod = Duration.getInstance(ecApplyEarlierTime.getGoal());
        globalPolicyData.setPcIPeriod(pcIPeriod);
        Duration pcApplyEarlierTime = Duration.getInstance(pcIPeriod.getGoal());
        globalPolicyData.setPcApplyEarlierTime(pcApplyEarlierTime);
        Duration pcOverlapTime = Duration.getInstance(pcApplyEarlierTime.getGoal());
        globalPolicyData.setPcOverlapTime(pcOverlapTime);
        byte[] pcMinCertsPerIPeriodBytes = new byte[1];
        System.arraycopy(pcOverlapTime.getGoal(), 0, pcMinCertsPerIPeriodBytes, 0, pcMinCertsPerIPeriodBytes.length);
        globalPolicyData.setPcMinCertsPerIPeriod(new Uint8(BigIntegers.fromUnsignedByteArray((byte[])pcMinCertsPerIPeriodBytes).intValue()));
        Duration pcUseSwitchTime = Duration.getInstance(GlobalPolicyData.getGoal(pcOverlapTime.getGoal(), 1));
        globalPolicyData.setPcUseSwitchTime(pcUseSwitchTime);
        byte[] pcUseSwitchAlgorithmBytes = new byte[1];
        System.arraycopy(pcUseSwitchTime.getGoal(), 0, pcUseSwitchAlgorithmBytes, 0, pcUseSwitchAlgorithmBytes.length);
        globalPolicyData.setPcUseSwitchAlgorithm(new Uint8(BigIntegers.fromUnsignedByteArray((byte[])pcUseSwitchAlgorithmBytes).intValue()));
        globalPolicyData.setGoal(GlobalPolicyData.getGoal(pcUseSwitchTime.getGoal(), 1));
        return globalPolicyData;
    }

    public static byte[] getGoal(byte[] data, int byteNum) {
        byte[] goal = new byte[data.length - byteNum];
        System.arraycopy(data, byteNum, goal, 0, goal.length);
        return goal;
    }

    @Override
    public Vector getSequenceValues() {
        Vector<OERObject> vector = new Vector<OERObject>();
        vector.add(this.itscaVersion);
        vector.add(this.gpfVersion);
        vector.add(this.ecPeriod);
        vector.add(this.ecApplyEarlierTime);
        vector.add(this.pcIPeriod);
        vector.add(this.pcApplyEarlierTime);
        vector.add(this.pcOverlapTime);
        vector.add(this.pcMinCertsPerIPeriod);
        vector.add(this.pcUseSwitchTime);
        vector.add(this.pcUseSwitchAlgorithm);
        return vector;
    }
}

