/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1.scms.lpf;

import com.xdja.pki.itsca.oer.asn1.base.Choice;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.asn1.scms.lpf.CustomPolicyData;
import com.xdja.pki.itsca.oer.asn1.scms.lpf.GlobalPolicyData;
import com.xdja.pki.itsca.oer.asn1.scms.lpf.LocalPolicyData;
import java.math.BigInteger;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;

public class Policy
extends Choice {
    private GlobalPolicyData global;
    private CustomPolicyData custom;
    private LocalPolicyData local;

    public GlobalPolicyData getGlobal() {
        return this.global;
    }

    public void setGlobal(GlobalPolicyData global) {
        this.addIndex(0);
        this.global = global;
    }

    public CustomPolicyData getCustom() {
        return this.custom;
    }

    public void setCustom(CustomPolicyData custom) {
        this.addIndex(1);
        this.custom = custom;
    }

    public LocalPolicyData getLocal() {
        return this.local;
    }

    public void setLocal(LocalPolicyData local) {
        this.addIndex(2);
        this.local = local;
    }

    public static Policy getInstance(byte[] data) throws Exception {
        Policy policy = new Policy();
        BigInteger choice = BigIntegers.fromUnsignedByteArray((byte[])data, (int)0, (int)1);
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        if (choice.intValue() - 128 == 0) {
            GlobalPolicyData globalPolicyData = GlobalPolicyData.getInstance(goal);
            policy.setGlobal(globalPolicyData);
            policy.setGoal(globalPolicyData.getGoal());
        } else if (choice.intValue() - 128 == 1) {
            CustomPolicyData customPolicyData = CustomPolicyData.getInstance(goal);
            policy.setCustom(customPolicyData);
            policy.setGoal(customPolicyData.getGoal());
        } else if (choice.intValue() - 128 == 2) {
            LocalPolicyData localPolicyData = LocalPolicyData.getInstance(goal);
            policy.setLocal(localPolicyData);
            policy.setGoal(localPolicyData.getGoal());
        } else {
            throw new Exception("unsupported Policy type " + choice.intValue());
        }
        return policy;
    }

    @Override
    public Vector getChoiceValues() {
        Vector<Sequence> vector = new Vector<Sequence>();
        vector.add(this.global);
        vector.add(this.custom);
        vector.add(this.local);
        return vector;
    }
}

