/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.asn1.scms.lpf;

import com.xdja.pki.itsca.oer.asn1.Time64;
import com.xdja.pki.itsca.oer.asn1.base.OERObject;
import com.xdja.pki.itsca.oer.asn1.base.OctetString;
import com.xdja.pki.itsca.oer.asn1.base.Sequence;
import com.xdja.pki.itsca.oer.asn1.scms.lpf.Policy;
import java.util.Vector;
import org.bouncycastle.util.BigIntegers;

public class ToBeSignedPolicyData
extends Sequence {
    private OctetString policyID;
    private Time64 generationTime;
    private Policy policy;

    public ToBeSignedPolicyData(boolean isExtension, boolean hasOptional) {
        super(isExtension, hasOptional);
    }

    public ToBeSignedPolicyData() {
        super(false, false);
    }

    public OctetString getPolicyID() {
        return this.policyID;
    }

    public void setPolicyID(OctetString policyID) {
        this.policyID = policyID;
    }

    public Time64 getGenerationTime() {
        return this.generationTime;
    }

    public void setGenerationTime(Time64 generationTime) {
        this.generationTime = generationTime;
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public void setPolicy(Policy policy) {
        this.policy = policy;
    }

    public static ToBeSignedPolicyData getInstance(byte[] data) throws Exception {
        ToBeSignedPolicyData toBeSignedPolicyData = new ToBeSignedPolicyData();
        OctetString policyID = OctetString.getInstance(data);
        toBeSignedPolicyData.setPolicyID(policyID);
        byte[] generationTimeBytes = new byte[8];
        System.arraycopy(policyID.getGoal(), 0, generationTimeBytes, 0, generationTimeBytes.length);
        Time64 generationTime = new Time64(BigIntegers.fromUnsignedByteArray((byte[])generationTimeBytes).longValue());
        toBeSignedPolicyData.setGenerationTime(generationTime);
        byte[] goal = new byte[policyID.getGoal().length - 8];
        System.arraycopy(policyID.getGoal(), 8, goal, 0, goal.length);
        Policy policy = Policy.getInstance(goal);
        toBeSignedPolicyData.setPolicy(policy);
        toBeSignedPolicyData.setGoal(policy.getGoal());
        return toBeSignedPolicyData;
    }

    @Override
    public Vector getSequenceValues() {
        Vector<OERObject> vector = new Vector<OERObject>();
        vector.add(this.policyID);
        vector.add(this.generationTime);
        vector.add(this.policy);
        return vector;
    }
}

