/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.cert;

import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import com.xdja.pki.itsca.oer.asn1.CRL;
import com.xdja.pki.itsca.oer.asn1.HashedId8;
import com.xdja.pki.itsca.oer.asn1.RevokeInfo;
import com.xdja.pki.itsca.oer.asn1.SequenceOfRevokeInfo;
import com.xdja.pki.itsca.oer.cert.RevokeInfoHolder;
import com.xdja.pki.itsca.oer.cert.bean.OERCRL;
import com.xdja.pki.itsca.oer.cert.bean.OERRevokeInfo;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import com.xdja.pki.itsca.oer.utils.TimeUtils;
import java.util.ArrayList;
import org.bouncycastle.util.BigIntegers;

public class CRLHolder {
    public static OERCRL build(byte[] data) throws Exception {
        CRL crl = CRL.getInstance(data);
        OERCRL oercrl = new OERCRL();
        try {
            HashedId8 hashedId8 = crl.getIssuerId().getCertificateDigest().getHashedId8();
            oercrl.setSignerHashId8(ByteArrayUtils.hexEncode(hashedId8.getString()));
        }
        catch (Exception hashedId8) {
            // empty catch block
        }
        byte[] bytes = GMSSLSM3DigestUtils.digestByYunhsm((byte[])data);
        byte[] goal = new byte[8];
        System.arraycopy(bytes, bytes.length - 8, goal, 0, goal.length);
        oercrl.setSelfHashId8(ByteArrayUtils.hexEncode(goal));
        SequenceOfRevokeInfo entries = crl.getToBeSignedCrl().getEntries();
        ArrayList<OERRevokeInfo> infos = new ArrayList<OERRevokeInfo>();
        for (RevokeInfo revokeInfo : entries.getRevokeInfos()) {
            OERRevokeInfo build = RevokeInfoHolder.build(revokeInfo.getEncode());
            infos.add(build);
        }
        oercrl.setList(infos);
        long issueDate = BigIntegers.fromUnsignedByteArray((byte[])crl.getToBeSignedCrl().getIssueDate().getEncode()).longValue();
        long nextDate = BigIntegers.fromUnsignedByteArray((byte[])crl.getToBeSignedCrl().getNextCrl().getEncode()).longValue();
        oercrl.setIssueDate(TimeUtils.getTime(issueDate));
        oercrl.setNextDate(TimeUtils.getTime(nextDate));
        oercrl.setCrlSerial(BigIntegers.fromUnsignedByteArray((byte[])crl.getToBeSignedCrl().getCrlSerial().getEncode()).longValue());
        return oercrl;
    }
}

