/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.cert;

import com.xdja.pki.itsca.oer.asn1.HashAlgorithm;
import com.xdja.pki.itsca.oer.asn1.RevokeInfo;
import com.xdja.pki.itsca.oer.cert.bean.OERRevokeInfo;
import com.xdja.pki.itsca.oer.utils.TimeUtils;
import java.math.BigInteger;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;

public class RevokeInfoHolder {
    public static OERRevokeInfo build(byte[] data) throws Exception {
        RevokeInfo revokeInfo = RevokeInfo.getInstance(data);
        OERRevokeInfo info = new OERRevokeInfo();
        HashAlgorithm hashAlg = revokeInfo.getHashAlgorithm();
        BigInteger choice = BigIntegers.fromUnsignedByteArray((byte[])hashAlg.getEncode(), (int)0, (int)1);
        if (choice.intValue() == 0) {
            info.setHashAlgorithm("SGD_SM3");
        } else {
            info.setHashAlgorithm("SHA_256");
        }
        String certId = Hex.toHexString((byte[])revokeInfo.getHashedId10().getString());
        info.setIssueHashId10(certId);
        if (null != revokeInfo.getExpiry()) {
            String time = TimeUtils.getTime(BigIntegers.fromUnsignedByteArray((byte[])revokeInfo.getExpiry().getEncode()).longValue());
            info.setExpiry(time);
        }
        return info;
    }
}

