/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM3DigestUtils;
import com.xdja.pki.itsca.oer.app.SignatureVerify;
import com.xdja.pki.itsca.oer.asn1.Certificate;
import com.xdja.pki.itsca.oer.asn1.SecuredMessage;
import com.xdja.pki.itsca.oer.asn1.SignedData;
import com.xdja.pki.itsca.oer.asn1.ValidityPeriod;
import com.xdja.pki.itsca.oer.cert.CertificateHolder;
import com.xdja.pki.itsca.oer.cert.bean.OERCertificate;
import com.xdja.pki.itsca.oer.enums.EccPointTypeEnum;
import com.xdja.pki.itsca.oer.utils.BCUtils;
import com.xdja.pki.itsca.oer.utils.ByteArrayUtils;
import com.xdja.pki.itsca.oer.utils.TimeUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OERUtils {
    private static Logger logger = LoggerFactory.getLogger(OERUtils.class);

    public static boolean checkPublicKey(String key) {
        String x = key.substring(0, 64);
        String y = key.substring(64);
        byte[] xCrood = Hex.decode((String)x);
        byte[] yCrood = Hex.decode((String)y);
        try {
            GMSSLX509Utils.convertSM2PublicKey((byte[])xCrood, (byte[])yCrood);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String pointTo(String point) {
        while (point.length() <= 7) {
            point = "0" + point;
        }
        int length = point.length() - 7;
        String decimal = point.substring(length);
        String integer = point.substring(0, length);
        point = integer + "." + decimal;
        return point;
    }

    public static byte[] readByteArray(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IOException("Input stream is null");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static OERCertificate convertOERCertificate(InputStream inputStream) throws Exception {
        if (inputStream == null) {
            throw new Exception("Input stream is null");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
        return OERUtils.convertOERCertificate(byteArrayOutputStream.toByteArray());
    }

    public static OERCertificate convertOERCertificate(byte[] encode) throws Exception {
        return CertificateHolder.build(encode);
    }

    public static boolean verifyOerSignature(byte[] verifyCertData, byte[] signCertData) throws Exception {
        OERCertificate signCert = CertificateHolder.build(signCertData);
        byte[] encode = Certificate.getInstance(verifyCertData).getTbsCert().getEncode();
        byte[] tbsHash = GMSSLSM3DigestUtils.digestByYunhsm((byte[])encode);
        if (OERUtils.isEqual(verifyCertData, signCertData)) {
            byte[] nullHash = GMSSLSM3DigestUtils.digestByYunhsm((byte[])"".getBytes());
            byte[] hash = OERUtils.buildUpByte(tbsHash, nullHash);
            return SignatureVerify.verify(signCert.getSignPublicKey(), hash, Certificate.getInstance(verifyCertData).getSignature());
        }
        byte[] signCertHash = GMSSLSM3DigestUtils.digestByYunhsm((byte[])signCertData);
        byte[] hash = OERUtils.buildUpByte(tbsHash, signCertHash);
        return SignatureVerify.verify(signCert.getSignPublicKey(), hash, Certificate.getInstance(verifyCertData).getSignature());
    }

    public static byte[] buildUpByte(byte[] var1, byte[] var2) {
        byte[] data = new byte[var1.length + var2.length];
        System.arraycopy(var1, 0, data, 0, var1.length);
        System.arraycopy(var2, 0, data, var1.length, var2.length);
        return data;
    }

    public static String generatePublicKey() throws Exception {
        ECPublicKey ecPublicKey = (ECPublicKey)BCUtils.generateSM2KeyPairByBC().getPublic();
        return OERUtils.convertPublicKey(ecPublicKey);
    }

    public static String convertPublicKey(PublicKey publicKey) {
        if (publicKey == null) {
            return null;
        }
        ECPublicKey ecPublicKey = (ECPublicKey)publicKey;
        byte[] x = ByteArrayUtils.changeByteArrayLength(ecPublicKey.getW().getAffineX());
        byte[] y = ByteArrayUtils.changeByteArrayLength(ecPublicKey.getW().getAffineY());
        String xx = Hex.toHexString((byte[])x);
        String yy = Hex.toHexString((byte[])y);
        return xx + yy;
    }

    public static String getHashIdString(byte[] data, int len) throws Exception {
        byte[] hash = OERUtils.getHashId(data, len);
        return Hex.toHexString((byte[])hash);
    }

    public static byte[] getHashId(byte[] data, int len) throws Exception {
        byte[] hash = GMSSLSM3DigestUtils.digestByYunhsm((byte[])data);
        byte[] bytes = new byte[len];
        System.arraycopy(hash, hash.length - len, bytes, 0, bytes.length);
        return bytes;
    }

    public static byte[] subByteHashId(byte[] data, int len) throws Exception {
        byte[] bytes = new byte[len];
        System.arraycopy(data, data.length - len, bytes, 0, bytes.length);
        return bytes;
    }

    public static String getHashId8String(byte[] data) throws Exception {
        byte[] hashId = OERUtils.getHashId(data, 8);
        return Hex.toHexString((byte[])hashId);
    }

    public static String getHashId10String(byte[] data) throws Exception {
        byte[] hashId = OERUtils.getHashId(data, 10);
        return Hex.toHexString((byte[])hashId);
    }

    public static byte[] getHashId8(byte[] data) throws Exception {
        return OERUtils.getHashId(data, 8);
    }

    public static byte[] getHashId10(byte[] data) throws Exception {
        return OERUtils.getHashId(data, 10);
    }

    public static boolean isEqual(byte[] arr1, byte[] arr2) {
        int i;
        if (arr1.length != arr2.length) {
            return false;
        }
        boolean flag1 = true;
        boolean flag2 = true;
        for (i = 0; i < arr1.length; ++i) {
            if (arr1[i] == arr2[i]) continue;
            flag1 = false;
        }
        if (!flag1) {
            for (i = 0; i < arr1.length; ++i) {
                if (arr1[i] == arr2[arr1.length - 1 - i]) continue;
                flag2 = false;
            }
        }
        return flag1 || flag2;
    }

    public static Certificate getCertificate(String path) throws Exception {
        byte[] bytes = OERUtils.readFile(path);
        return Certificate.getInstance(bytes);
    }

    public static boolean verifySecuredMessageSignatureByCert(Certificate cert, SecuredMessage securedMessage) throws Exception {
        SignedData signedData = securedMessage.getPayload().getSignedData();
        byte[] encode = signedData.getTbs().getEncode();
        byte[] tbsHash = GMSSLSM3DigestUtils.digestByYunhsm((byte[])encode);
        byte[] certHash = GMSSLSM3DigestUtils.digestByYunhsm((byte[])cert.getEncode());
        byte[] hash = OERUtils.buildUpByte(tbsHash, certHash);
        OERCertificate build = CertificateHolder.build(cert.getEncode());
        return SignatureVerify.verify(build.getSignPublicKey(), hash, signedData.getSign());
    }

    public static boolean verifySecuredMessageSignatureBySelf(PublicKey publicKey, SecuredMessage securedMessage) throws Exception {
        SignedData signedData = securedMessage.getPayload().getSignedData();
        byte[] encode = signedData.getTbs().getEncode();
        byte[] tbsHash = GMSSLSM3DigestUtils.digestByYunhsm((byte[])encode);
        byte[] nullHash = GMSSLSM3DigestUtils.digestByYunhsm((byte[])"".getBytes());
        byte[] hash = OERUtils.buildUpByte(tbsHash, nullHash);
        return SignatureVerify.verify(publicKey, hash, signedData.getSign());
    }

    public static Date getStartTime(ValidityPeriod validityPeriod, Date caStartDate, Date caEndDate) throws Exception {
        if (null != validityPeriod.getTimeStartAndEnd()) {
            BigInteger startTime = BigIntegers.fromUnsignedByteArray((byte[])validityPeriod.getTimeStartAndEnd().getStartValidity().getEncode());
            Date reqStartTime = TimeUtils.getTimeFromNumber(startTime.longValue());
            if (reqStartTime.getTime() >= caEndDate.getTime()) {
                throw new Exception("\u8bbe\u7f6e\u7684\u8d77\u59cb\u65f6\u95f4\u4e0d\u80fd\u8d85\u8fc7CA\u8bc1\u4e66\u6709\u6548\u671f");
            }
            return caStartDate.getTime() > reqStartTime.getTime() ? caStartDate : reqStartTime;
        }
        return null;
    }

    public static Date getEndTime(ValidityPeriod validityPeriod, Date caEndDate, Date startTime, int days) throws Exception {
        BigInteger endTime;
        if (null != validityPeriod.getTimeEnd()) {
            endTime = BigIntegers.fromUnsignedByteArray((byte[])validityPeriod.getTimeEnd().getEncode());
        } else if (null != validityPeriod.getTimeStartAndEnd()) {
            endTime = BigIntegers.fromUnsignedByteArray((byte[])validityPeriod.getTimeStartAndEnd().getEndValidity().getEncode());
        } else {
            throw new Exception("\u672a\u914d\u7f6e\u65f6\u95f4\u9650\u5b9a");
        }
        Date reqEndTime = TimeUtils.getTimeFromNumber(endTime.longValue());
        if (reqEndTime.getTime() <= startTime.getTime()) {
            throw new Exception("\u8bbe\u7f6e\u7684\u5931\u6548\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u8bbe\u7f6e\u7684\u8d77\u59cb\u65f6\u95f4 \u7ed3\u675f\u65f6\u95f4" + reqEndTime + " \u8d77\u59cb\u65f6\u95f4 {}" + startTime);
        }
        if (caEndDate.getTime() < reqEndTime.getTime()) {
            reqEndTime = caEndDate;
        }
        long validTime = 86400000L * (long)days;
        if (reqEndTime.getTime() - startTime.getTime() > validTime) {
            reqEndTime = new Date(startTime.getTime() + validTime);
        }
        return reqEndTime;
    }

    public static byte[] readCertFileByteArray(String path, String certFileName) throws Exception {
        String certFilePath = path + File.separator + certFileName;
        return OERUtils.readFile(certFilePath);
    }

    public static OERCertificate readCertFile(String path, String certFileName) throws Exception {
        String certFilePath = path + File.separator + certFileName;
        byte[] file = OERUtils.readFile(certFilePath);
        return CertificateHolder.build(file);
    }

    public static byte[] readFile(String fileName) throws IOException {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(fileName);
        if (inputStream == null) {
            inputStream = new FileInputStream(fileName);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static ECPublicKey decodePoint(EccPointTypeEnum type, byte[] data) throws Exception {
        byte[] encode;
        String eccSm2Name = "sm2p256v1";
        ECNamedCurveParameterSpec ecParameterSpec = ECNamedCurveTable.getParameterSpec((String)eccSm2Name);
        ECCurve curve = ecParameterSpec.getCurve();
        switch (type) {
            case UNCOMPRESSED: {
                byte[] bytes = new byte[]{4};
                encode = ByteArrayUtils.buildUpByte(bytes, data);
                break;
            }
            case COMPRESSED_Y0: {
                byte[] bytes = new byte[]{2};
                encode = ByteArrayUtils.buildUpByte(bytes, data);
                break;
            }
            case COMPRESSED_Y1: {
                byte[] bytes = new byte[]{3};
                encode = ByteArrayUtils.buildUpByte(bytes, data);
                break;
            }
            default: {
                throw new Exception("eccPoint type is error " + type.value);
            }
        }
        ECPoint ecPoint = curve.decodePoint(encode);
        ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(ecPoint, (ECParameterSpec)ecParameterSpec);
        return new BCECPublicKey(eccSm2Name, ecPublicKeySpec, BouncyCastleProvider.CONFIGURATION);
    }
}

