/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.itsca.oer.app;

import com.xdja.pki.gmssl.asn1.crypto.ASN1SM2Cipher;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.sdf.SdfPrivateKey;
import com.xdja.pki.gmssl.crypto.utils.GMSSLECIESEncryptUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2EncryptUtils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLCryptoType;
import com.xdja.pki.itsca.oer.asn1.EccCurve;
import com.xdja.pki.itsca.oer.asn1.EccPoint;
import com.xdja.pki.itsca.oer.asn1.EciesEncryptedKey;
import com.xdja.pki.itsca.oer.asn1.base.OctetString;
import com.xdja.pki.itsca.oer.utils.BCUtils;
import java.math.BigInteger;
import java.security.PrivateKey;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KekResolveUtils {
    private static Logger logger = LoggerFactory.getLogger(KekResolveUtils.class);

    public static byte[] getPlain(EciesEncryptedKey kek, PrivateKey privateKey) throws Exception {
        EccPoint v = kek.getV();
        OctetString x = v.getUncompressed().getX();
        byte[] datass = new byte[112];
        System.arraycopy(x.getString(), 0, datass, 0, x.getString().length);
        OctetString y = v.getUncompressed().getY();
        System.arraycopy(y.getString(), 0, datass, 32, y.getString().length);
        System.arraycopy(kek.getT().getString(), 0, datass, 64, kek.getT().getString().length);
        System.arraycopy(kek.getC().getString(), 0, datass, 96, kek.getC().getString().length);
        ASN1SM2Cipher asn1SM2Cipher = new ASN1SM2Cipher(x.getString(), y.getString(), kek.getT().getString(), kek.getC().getString());
        if (kek.getEccCurve().readValue().getIndex() == EccCurve.SGD_SM2.getIndex()) {
            if (privateKey instanceof SdfPrivateKey) {
                return GMSSLSM2EncryptUtils.decryptASN1BySdf((SdfCryptoType)SdfCryptoType.YUNHSM, (int)((SdfPrivateKey)privateKey).getIndex(), (String)new String(((SdfPrivateKey)privateKey).getPassword()), (byte[])asn1SM2Cipher.getEncoded(), (int)0, (int)asn1SM2Cipher.getEncoded().length);
            }
            return BCUtils.sm2DecryptASN1ByBC(privateKey, asn1SM2Cipher.getEncoded());
        }
        if (kek.getEccCurve().readValue().getIndex() == EccCurve.NIST_P_256.getIndex()) {
            byte[] cipher = ASN1SM2Cipher.pieceC1C2C3((byte[])BigIntegers.asUnsignedByteArray((BigInteger)asn1SM2Cipher.getxCoordinate()), (byte[])BigIntegers.asUnsignedByteArray((BigInteger)asn1SM2Cipher.getyCoordinate()), (byte[])asn1SM2Cipher.getHash(), (byte[])asn1SM2Cipher.getCipherText());
            if (privateKey instanceof SdfPrivateKey) {
                return GMSSLECIESEncryptUtils.decrypt((GMSSLCryptoType)GMSSLCryptoType.YUNHSM, (PrivateKey)privateKey, (byte[])cipher);
            }
            return GMSSLECIESEncryptUtils.decrypt((GMSSLCryptoType)GMSSLCryptoType.BC, (PrivateKey)privateKey, (byte[])cipher);
        }
        throw new Exception("\u4e0d\u652f\u6301\u7684\u66f2\u7ebf\u7c7b\u578b \uff1a" + kek.getEccCurve().readValue().getIndex());
    }
}

